﻿-- Update by Silentdave (Ravegrobber - Kul'Tiras EU), humfras
-- Due to various XML attribute changes in 3.0, the auto show and timer controlled hide of the PoisonerMenu no longer works. 
-- Thus added OnMouseUp to Minimapbutton in the XML file to toggle PoisonerMenu showing/hiding (linked to PoisonerMenu_Toggle() in this file
local MSQ = LibStub("Masque", true)
local player_entered_world = false

Poisoner_Patterns = {	--reworked Poisoner_FindPoisons()
[2892] = "DP",	--Tödliches Gift
[3775] = "CP",	--Verkrüppelndes Gift
[5237] = "MP",	--Gedankenbenebelndes Gift
[6947] = "IP",	--Sofort wirkendes Gift
[10918] = "WP",	--Wundgift
}
Poisoner_SpellIDs = {
[2823] = "DP",	--Tödliches Gift
[3408] = "CP",	--Verkrüppelndes Gift
[5761] = "MP",	--Gedankenbenebelndes Gift
[8679] = "IP",	--Sofort wirkendes Gift
[13219] = "WP",	--Wundgift
}

local locale = GetLocale()
local ENRAGE
if (locale == "enUS") then
	ENRAGE = "Enrage"
elseif (locale == "deDE") then
	ENRAGE = "Wut"
elseif (locale == "esES") then
	ENRAGE = "Enfurecer"
elseif (locale == "frFR") then
	ENRAGE = "Enrager"
elseif (locale == "ruRU") then
	ENRAGE = "Исступление"
else
	ENRAGE = "Enrage"
end

local _, cls = UnitClass("player");

local PBT = CreateFrame("GameTooltip","PoisonerBuffTooltip", nil, "GameTooltipTemplate")
local function ResetTooltip()
	PBT:Hide()
	PBT:SetOwner(WorldFrame, "ANCHOR_NONE")
	PBT:ClearLines()
end
-- store original versions of API calls
local old_UnitBuff = UnitBuff
local old_UnitAura = UnitAura

-- OnLoad event
function Poisoner_OnLoad(self)
	-- register for clicks
	--self:RegisterForClicks("LeftButtonUp", "RightButtonUp");
	--self:RegisterForDrag("LeftButton");
	-- need this for the initial load
	self:RegisterEvent("VARIABLES_LOADED");
	self:RegisterEvent("PLAYER_ENTERING_WORLD");
	self:RegisterEvent("PLAYER_REGEN_DISABLED");
	self:RegisterEvent("PLAYER_REGEN_ENABLED");
	self:RegisterEvent("UNIT_SPELLCAST_INTERRUPTED");
	self:RegisterEvent("BAG_UPDATE");
      -- register a slash command
        SLASH_POISONER1 = "/poisoner";
        SlashCmdList["POISONER"] = function(msg)
                Poisoner_ProcessCommand(msg);
        end;
	Poisoner_PrintDebug = false
	
	Poisoner_QuickButtonVisible = 0;
	
	StaticPopupDialogs["POISONER_QUESTION_ENABLE"] = {
		preferredIndex = STATICPOPUP_NUMDIALOGS,
		text = ""..POISONER_TITLE..":\n "..POISONER_NOTAROGUE.."",
		button1 = YES,
		button3 = NO,
		button2 = DISABLE,
		OnAccept = function() Poisoner_Enable() end,
		OnAlt = function () end,
		OnCancel = function() Poisoner_Disable() end,
		timeout = 0,
		whileDead = 0,
		hideOnEscape = 1
	}
	
	StaticPopupDialogs["POISONER_STARTED_ONCE"] = {
		preferredIndex = STATICPOPUP_NUMDIALOGS,
		text = ""..POISONER_TITLE.."\n"..OPTION_RESTART_REQUIREMENT.."",
		button1 = OKAY,
		button2 = CANCEL,
		OnAccept = function() Poisoner_RestartOnce() end,
		timeout = 0,
		whileDead = 0,
		hideOnEscape = 1
	}
	
	StaticPopupDialogs["POISONER_WELCOME_TO_V4"] = {
		preferredIndex = STATICPOPUP_NUMDIALOGS,
		text = ""..POISONER_WELCOME4.."",
		button1 = OKAY,
		timeout = 0,
		whileDead = 0,
		hideOnEscape = 1
	}
	
	Poisoner_Debug("Poisoner Loaded");

	-- hook API functions
	UnitBuff = Poisoner_UnitBuff
	
end

function Poisoner_OnEvent(self, event, ...)
	if (event == "VARIABLES_LOADED") then
		PoisonerOptions_CheckDB()
		Poisoner_OnVariablesLoaded(self);
	elseif (event == "PLAYER_ENTERING_WORLD") then
		PoisonerOptions_CheckDB()
		player_entered_world = true
		local PoisonerMasque = IsAddOnLoaded("Poisoner_Masque")
		if PoisonerMasque and not Poisoner_Masque_Initiated then
			Poisoner_Masque_Init()
		end
		Poisoner_CreateButtons()
		Poisoner_CheckQuickButton()
	elseif (event == "PLAYER_REGEN_DISABLED") then
		Poisoner_OnEnterCombat();
	elseif (event == "PLAYER_REGEN_ENABLED") then
		Poisoner_OnLeaveCombat();
	elseif event == "UNIT_SPELLCAST_INTERRUPTED" then
		Poisoner_UNIT_SPELLCAST_INTERRUPTED(...)
	elseif event == "BAG_UPDATE" then
		if not Poisoner_MerchantIsShown then return end
		Poisoner_ReCountPoisons()
	end
end

function Poisoner_OnVariablesLoaded(self)
	if (POISONER_CONFIG == nil) then
		POISONER_CONFIG = {};
		local _, cls = UnitClass("player");
		if (cls == "ROGUE") then
			POISONER_CONFIG.Enabled = 1;
		elseif not (cls == "ROGUE") then
			StaticPopup_Show("POISONER_QUESTION_ENABLE");
		end
	end
	if ( not POISONER_CONFIG.Enabled ) then
		local _, cls = UnitClass("player");
		if (cls == "ROGUE") then
			POISONER_CONFIG.Enabled = 1;
		elseif not (cls == "ROGUE") then
			StaticPopup_Show("POISONER_QUESTION_ENABLE");
		end
	end
	if ( not POISONER_CONFIG.StartedOnce ) then
		POISONER_CONFIG.StartedOnce = 0;
	end
	if (POISONER_CONFIG.StartedOnce == 0) and (POISONER_CONFIG.Enabled == 1) then
		Poisoner_GetPoisonNames();
		StaticPopup_Show("POISONER_STARTED_ONCE");
	end
	
	if (POISONER_CONFIG.Menu.Scale ~= nil) then
		PoisonerMenu:SetScale(POISONER_CONFIG.Menu.Scale);
	end
	Poisoner_SetPosition(POISONER_CONFIG.Menu.Position or "bottomleft");
	
	if (POISONER_CONFIG.Enabled == 1) then
		PoisonerStateHeader:Show();
		if (POISONER_CONFIG.Buttons.FreeButton.Active == 1) then
			Poisoner_FreeButton:Show();
		elseif (POISONER_CONFIG.Buttons.FreeButton.Active == 0) then
			Poisoner_FreeButton:Hide();
		end
	else
		PoisonerStateHeader:Hide();
		Poisoner_FreeButton:Hide();
	end
	
	PoisonerStateHeader.inCombat = false;
	PoisonerStateHeader:SetAttribute("state", "0");
	self:UnregisterEvent("VARIABLES_LOADED");
end

function Poisoner_CheckBuff(name, rank, icon, count, debuffType, duration, expirationTime, unitCaster, isStealable, shouldConsolidate, spellID, canApplyAura, isBossDebuff, ...)
	-- this is the only one we need specifically, but all may be needed by Enrage-checking code below
	local uid = select(1,...)
	
	-- if unitbuff/unitaura is being called on a unit that isn't target or focus, ignore it and return default data
	if (uid ~= "target" and uid ~= "focus") then
		return name, rank, icon, count, debuffType, duration, expirationTime, unitCaster, isStealable, shouldConsolidate, spellID, canApplyAura, isBossDebuff
	end

	-- if we have borders enabled for this unit type, this class can dispel enemy buffs in general, and the unit is an enemy
	if (((uid == "target") or (uid == "focus")) and cls == "ROGUE" and (UnitIsEnemy("player", uid) or UnitCanAttack("player", uid))) then
		-- check for valid dispellable buff
		
		-- check for Enrage buffs (but only if there is no "known" debuffType and the player can even dispel them)
		-- if it is, change the "debuffType" so 1: our type-checking code is simpler and 2: other addons could potentially get this info (?)
		if (debuffType == "") then
			ResetTooltip()
			PBT:SetUnitBuff(...) -- pass exact UnitBuff/UnitAura parameters to SetUnitBuff to make things easier
			if (PoisonerBuffTooltipTextRight1:GetText() == ENRAGE_STRING) then
				debuffType = "Enrage"
			end
		end

		-- if we can dispel it
		if (debuffType == "Enrage") then
			-- give it a border
			isStealable = 1
		--	print(uid.." has ENRAGE "..name)
		end
	end

	-- return all parameters (debuffType, unitCaster, and isStealable are potentially modified)
	return name, rank, icon, count, debuffType, duration, expirationTime, unitCaster, isStealable, shouldConsolidate, spellID, canApplyAura, isBossDebuff
end

-- API hook
-- modified in 1.3.9 to work with (unit, spellname, spellrank, filter) in addition to (unit, index, filter)
function Poisoner_UnitBuff(...)
	-- get default stuff
	local name, rank, icon, count, debuffType, duration, expirationTime, unitCaster, isStealable, shouldConsolidate, spellID, canApplyAura, isBossDebuff  = old_UnitBuff(...)

	-- if unitbuff is being called on a unit that isn't target or focus, ignore it and return default data
	local uid = select(1,...)
	if (uid ~= "target" and uid ~= "focus") then
		return name, rank, icon, count, debuffType, duration, expirationTime, unitCaster, isStealable, shouldConsolidate, spellID, canApplyAura, isBossDebuff
	end

	-- check actual buff info and return potentially modified info based on if we can dispel or not
	return Poisoner_CheckBuff(name, rank, icon, count, debuffType, duration, expirationTime, unitCaster, isStealable, shouldConsolidate, spellID, canApplyAura, isBossDebuff, ...)
end

-- Restart once to update locales in SavedVariables
function Poisoner_RestartOnce()
	Poisoner_GetPoisonNames();
	POISONER_CONFIG.StartedOnce = 1;
	ReloadUI();
end

-- when entering combat we need to pregenerate the buttons, as that cannot be done during lockdown
function Poisoner_OnEnterCombat()
	Poisoner_Debug("entering combat");
	PoisonerOptions_SettingsFrame:Hide();
	if ( POISONER_CONFIG.Menu.AutoHide.inCombat == 1 ) then
		PoisonerMenu:Hide();
	end
	PoisonerStateHeader.poisonCount = Poisoner_FindPoisons();
	Poisoner_CreateButtons();
	PoisonerStateHeader.inCombat = true;
end

function Poisoner_OnLeaveCombat()
	Poisoner_Debug("leaving combat");
	PoisonerStateHeader.inCombat = false;
	if PoisonerStateHeader.needUpdate then
		Poisoner_CreateButtons();
		Poisoner_CheckQuickButton();
		Poisoner_SecureHandler:LoadMenu();
		PoisonerStateHeader.needUpdate = false;
	end
end

function Poisoner_GetPoisonNames()

	--[[POISONER_CONFIG.Poisons = { 
		CPName = GetItemInfo(3775);	--Verkrüppelndes Gift
		MPName = GetItemInfo(5237);	--Gedankenbenebelndes Gift
		DPName = GetItemInfo(2892);	--Tödliches Gift
		IPName = GetItemInfo(6947);	--Sofort wirkendes Gift
		WPName = GetItemInfo(10918);	--Wundgift
	}]]
	
	if not POISONER_CONFIG.Poisons.CPName or POISONER_CONFIG.Poisons.CPName == nil then --Verkrüppelndes Gift
		POISONER_CONFIG.Poisons.CPName = GetItemInfo(3775);
	end
	if not POISONER_CONFIG.Poisons.MPName or POISONER_CONFIG.Poisons.MPName == nil then --Gedankenbenebelndes Gift
		POISONER_CONFIG.Poisons.MPName = GetItemInfo(5237);
	end
	if not POISONER_CONFIG.Poisons.DPName or POISONER_CONFIG.Poisons.DPName == nil then --Tödliches Gift
		POISONER_CONFIG.Poisons.DPName = GetItemInfo(2892);
	end
	if not POISONER_CONFIG.Poisons.IPName or POISONER_CONFIG.Poisons.IPName == nil then --Sofort wirkendes Gift
		POISONER_CONFIG.Poisons.IPName = GetItemInfo(6947);
	end
	if not POISONER_CONFIG.Poisons.WPName or POISONER_CONFIG.Poisons.WPName == nil then --Wundgift
		POISONER_CONFIG.Poisons.WPName = GetItemInfo(10918);
	end

end

--Check for interrupted/failed spell cast with the registered poisons
function Poisoner_UNIT_SPELLCAST_INTERRUPTED(...)
	local unit,spellName,rank,lineID,SpellID = ...
	if not Poisoner_SpellIDs[SpellID] then return end
--	print("UNIT_SPELLCAST_INTERRUPTED")	--DEBUG
--	print(...)	--DEBUG
	PoisonerStateHeader.poisonCount = Poisoner_FindPoisons()
	local button = _G["PoisonerMenuButton__"..Poisoner_SpellIDs[SpellID]]
	button.needUpdate = true
	Poisoner_OnItemButtonUpdate(button)
	
end

function Poisoner_ReCountPoisons()
	PoisonerStateHeader.poisonCount = Poisoner_FindPoisons()
--[[	if (not PoisonerStateHeader.inCombat) then
		Poisoner_CreateButtons()
	else]]
		for k,v in pairs(Poisoner_Patterns) do
		--	print(k,v)
			
			local tname = v
			local buttonName = "PoisonerMenuButton__"..tname;
			local button = _G[buttonName];
			
			if button and button:IsShown() then
				button.needUpdate = true
				Poisoner_OnItemButtonUpdate(button)
			end
			
		end
	--end
end

function Poisoner_OnItemButtonUpdate(button, elapsed)
	if not elapsed or elapsed == nil then elapsed = 2 end
	button.elapsed = button.elapsed + elapsed;
	if (button.needUpdate or button.elapsed > button.updateDelay) then
		-- find the current poison count for this button
		local itemName = button:GetAttribute("name")	--local _, _, itemName = string.find(button:GetName(), "^PoisonerMenuButton(.*)$");
		local count, rank;
		if (PoisonerStateHeader.poisonCount) then
			local rec = PoisonerStateHeader.poisonCount[itemName];
			if (rec) then
				count = rec.quantity;
				rank = rec.rank;
			end
		end
		
		-- and display it
		-- local cbutton = _G[button:GetName()];
		if (count and count > 0) then
			button:SetText(""..count);
			button:GetNormalTexture():SetVertexColor(1,1,1,1);
		else
			button:SetText("0");
			button:GetNormalTexture():SetVertexColor(0.5,0.5,0.5,1);
			button:GetHighlightTexture():SetVertexColor(0.5,0.5,0.5,1);
		end
		button.elapsed = 0;
		button.needUpdate = false;
	end
	
	if (Poisoner_QuickButtonVisible == 1) then
		Poisoner_CheckQuickButton()
	end
	
end

function Poisoner_OnMenuShow()
	--print("Poisoner OnMenuShow")
	-- find the current number of poisons available
	PoisonerStateHeader.poisonCount = Poisoner_FindPoisons();
	if (not PoisonerStateHeader.inCombat) then
		-- generate the appropriate buttons
		Poisoner_CreateButtons();
		if ( POISONER_CONFIG.Menu.AutoHide.Active == 1 ) then
			local d=POISONER_CONFIG.Menu.AutoHide.Time;
			local u=GetTime()+d;
			local t=u;
			local frame = Poisoner_FreeButton
			frame:SetScript("OnUpdate",function() if GetTime()>=t then PoisonerMenu:Hide();t=nil;frame:SetScript("OnUpdate",nil)end end)
		end
    end
	for _, t in pairs(Poisoner_FindPoisons()) do
	--	local tname = string.gsub(t.name, " ", "_")
		local tname = t.shortname
		local buttonName = "PoisonerMenuButton__"..tname;
		local button = _G[buttonName];
		if button ~= nil then
			Poisoner_OnItemButtonUpdate(button, 2)
		end
	end
end

function Poisoner_OnItemButtonClick(button, click)
	local itemName = button:GetAttribute("name")	--local _, _, itemName = string.find(button:GetName(), "^PoisonerMenuButton(.*)$");
	if (not SpellCanTargetItem()) then
		-- Poison is applying, decrement the count
		if (PoisonerStateHeader.poisonCount) then
			local rec = PoisonerStateHeader.poisonCount[itemName];
			if (rec) then
				rec.quantity = rec.quantity - 1;
			end
		end
	else
		-- still targetting, the box was displayed
		-- TODO: need to clear the cursor here somehow
	end
	button.needUpdate = true;
	
		local isModifier = IsModifierKeyDown();
		local modShift = IsShiftKeyDown();
		local modCtrl = IsControlKeyDown();
		local modAlt = IsAltKeyDown();
		local modifier
		if (( modShift == 1 ) and ( modCtrl == 1 ) and ( modAlt == 1 )) then
			modifier = "ShiftCtrlAlt";
		elseif (( modShift == 1 ) and ( modCtrl == 1 ) and ( modAlt ~= 1 )) then
			modifier = "ShiftCtrl";
		elseif (( modShift ~= 1 ) and ( modCtrl == 1 ) and ( modAlt == 1 )) then
			modifier = "CtrlAlt";
		elseif (( modShift == 1 ) and ( modCtrl ~= 1 ) and ( modAlt == 1 )) then
			modifier = "ShiftAlt";
		elseif (( modShift == 1 ) and ( modCtrl ~= 1 ) and ( modAlt ~= 1 )) then
			modifier = "Shift";
		elseif (( modShift ~= 1 ) and ( modCtrl == 1 ) and ( modAlt ~= 1 )) then
			modifier = "Ctrl";
		elseif (( modShift ~= 1 ) and ( modCtrl ~= 1 ) and ( modAlt == 1 )) then
			modifier = "Alt";
		else
			modifier = DEFAULT;
		end
		
		--print("Poisoner: "..modifier)	--Debug
				local COLOR_GREEN = "|cff00ff00";
				local COLOR_END = "|r";
	
				if ( click=="LeftButton" ) then
						local weaponID = GetInventoryItemID("player", 16)
						local weaponName, _, weaponRarity = GetItemInfo(weaponID)
						local color
						if (weaponRarity == 2) then color = "|cff1eff00"
						elseif (weaponRarity == 3) then color = "|cff0070dd"
						elseif (weaponRarity == 4) then color = "|cffa335ee"
						elseif (weaponRarity == 5) then color = "|cffff8000"
						elseif (weaponRarity == 6) or (weaponRarity == 7) then color = "|cffe6cc80"
						else color = "|cffffffff"
						end
					if ( POISONER_CONFIG.Preset.Overwrite == 1 ) then
						if ( isModifier ~= 1 ) then
							Poisoner_UpdatePoisonSlots(1, itemName)
						elseif ( modifier == "Shift" ) then
							Poisoner_UpdatePoisonSlots(2, itemName)
						elseif ( modifier == "Ctrl" ) then
							Poisoner_UpdatePoisonSlots(3, itemName)
						elseif ( modifier == "Alt" ) then
							Poisoner_UpdatePoisonSlots(4, itemName)
						end
					elseif ( POISONER_CONFIG.Preset.Overwrite == 0 ) --[[and ( isModifier ~= 1 )]] then
						modifier = "";
					end
					--if ( isModifier ~= 1 ) or ( ( isModifier == 1 ) and ( POISONER_CONFIG.Preset.Overwrite == 1 ) ) then
					if ( POISONER_CONFIG.PrintClickedPoison == 1 ) then
						print(""..INVTYPE_WEAPONMAINHAND.." "..modifier..": "..color..weaponName.."|r > "..COLOR_GREEN..itemName..COLOR_END)
					end
					--end
				elseif ( click=="RightButton" ) then
						local weaponID = GetInventoryItemID("player", 17)
						local weaponName, _, weaponRarity = GetItemInfo(weaponID)
						local color
						if (weaponRarity == 2) then color = "|cff1eff00"
						elseif (weaponRarity == 3) then color = "|cff0070dd"
						elseif (weaponRarity == 4) then color = "|cffa335ee"
						elseif (weaponRarity == 5) then color = "|cffff8000"
						elseif (weaponRarity == 6) or (weaponRarity == 7) then color = "|cffe6cc80"
						else color = "|cffffffff"
						end
					if ( POISONER_CONFIG.Preset.Overwrite == 1 ) then
						if ( isModifier ~= 1 ) then
							Poisoner_UpdatePoisonSlots(5, itemName)
						elseif ( modifier == "Shift" ) then
							Poisoner_UpdatePoisonSlots(6, itemName)
						elseif ( modifier == "Ctrl" ) then
							Poisoner_UpdatePoisonSlots(7, itemName)
						elseif ( modifier == "Alt" ) then
							Poisoner_UpdatePoisonSlots(8, itemName)
						end
					elseif ( POISONER_CONFIG.Preset.Overwrite == 0 ) --[[and ( isModifier ~= 1 )]] then
						modifier = "";
					end
					if ( POISONER_CONFIG.PrintClickedPoison == 1 ) then
						print(""..INVTYPE_WEAPONOFFHAND.." "..modifier..": "..color..weaponName.."|r > "..COLOR_GREEN..itemName..COLOR_END)
					end
				elseif ( click=="MiddleButton" ) then
						local weaponID = GetInventoryItemID("player", 18)
						local weaponName, _, weaponRarity = GetItemInfo(weaponID)
						local color
						if (weaponRarity == 2) then color = "|cff1eff00"
						elseif (weaponRarity == 3) then color = "|cff0070dd"
						elseif (weaponRarity == 4) then color = "|cffa335ee"
						elseif (weaponRarity == 5) then color = "|cffff8000"
						elseif (weaponRarity == 6) or (weaponRarity == 7) then color = "|cffe6cc80"
						else color = "|cffffffff"
						end
					if ( POISONER_CONFIG.Preset.Overwrite == 1 ) then
						if ( isModifier ~= 1 ) then
							Poisoner_UpdatePoisonSlots(9, itemName)
						elseif ( modifier == "Shift" ) then
							Poisoner_UpdatePoisonSlots(10, itemName)
						elseif ( modifier == "Ctrl" ) then
							Poisoner_UpdatePoisonSlots(11, itemName)
						elseif ( modifier == "Alt" ) then
							Poisoner_UpdatePoisonSlots(12, itemName)
						end						
					elseif ( POISONER_CONFIG.Preset.Overwrite == 0 ) --[[and ( isModifier ~= 1 )]] then
						modifier = "";
					end
						local weaponName, weaponLink, weaponRarity, weaponLevel, weaponMinLevel, weaponType, weaponSubType, weaponStackCount, weaponEquipLoc, weaponTexture, weaponSellPrice = GetItemInfo(GetInventoryItemID("player", "18"));
						local weaponSubTypeEquiped, rank, icon, cost, isFunnel, powerType, castTime, minRange, maxRange = GetSpellInfo(2567);
						local isThrowWeapon, EqualStrings = string.find(weaponSubType, ""..weaponSubTypeEquiped.."")
						if ( POISONER_CONFIG.PrintClickedPoison == 1 ) then
							if ( isThrowWeapon ) then
								print(""..INVTYPE_THROWN.." "..modifier..": "..color..weaponName.."|r > "..COLOR_GREEN..itemName..COLOR_END)
							else
								print(""..INVTYPE_THROWN..": "..color..weaponName.."|r > |cffff0000"..ERR_INVALID_ITEM_TARGET.."|r")						
							end
						end
				else
					print("No click registered")
				end
				
				
	
	if InCombatLockdown() then
		PoisonerStateHeader.needUpdate = true
	else
		Poisoner_CheckQuickButton();
	end
	
end

function Poisoner_UpdatePoisonSlots(id, itemName)

	--_G["Poisoner_PoisonSlotFrame"..id]:SetAttribute("Text",itemName)
	if id == 1 then
		Poisoner_Poison16.Name = itemName
	elseif id == 2 then
		Poisoner_Poison16_SHIFT.Name = itemName
	elseif id == 3 then
		Poisoner_Poison16_CTRL.Name = itemName
	elseif id == 4 then
		Poisoner_Poison16_ALT.Name = itemName
	elseif id == 5 then
		Poisoner_Poison17.Name = itemName
	elseif id == 6 then
		Poisoner_Poison17_SHIFT.Name = itemName
	elseif id == 7 then
		Poisoner_Poison17_CTRL.Name = itemName
	elseif id == 8 then
		Poisoner_Poison17_ALT.Name = itemName
	elseif id == 9 then
		Poisoner_Poison18.Name = itemName
	elseif id == 10 then
		Poisoner_Poison18_SHIFT.Name = itemName
	elseif id == 11 then
		Poisoner_Poison18_CTRL.Name = itemName
	elseif id == 12 then
		Poisoner_Poison18_ALT.Name = itemName
	end

	Poisoner_PoisonSlots = {
		Poisoner_Poison16,
		Poisoner_Poison16_SHIFT,
		Poisoner_Poison16_CTRL,
		Poisoner_Poison16_ALT,
		Poisoner_Poison17,
		Poisoner_Poison17_SHIFT,
		Poisoner_Poison17_CTRL,
		Poisoner_Poison17_ALT,
		Poisoner_Poison18,
		Poisoner_Poison18_SHIFT,
		Poisoner_Poison18_CTRL,
		Poisoner_Poison18_ALT,
	}
	
	Poisoner_SecureHandler:LoadMenu()
	
end

function Poisoner_ShowTooltip(self)
--	print("Poisoner_ShowTooltip")
--	print(self:GetName())
--[[	for _, t in pairs(Poisoner_FindPoisons()) do
		if t.name == self.Name then
		--	print("t.Name == self.Name")
			Poisoner_Tooltip(self,t.bag,t.bagslot,t.name)
		end
	end]]
	Poisoner_Tooltip(self,self.Bag,self.Bagslot,self.Name)
end
function Poisoner_HideTooltip(self, ...)
--	print("Poisoner_HideTooltip")
--	print(self:GetName())
	GameTooltip:Hide()
end
function Poisoner_PostClick(self, button)
--	print("Poisoner_PostClick")
--	print(self:GetName())
--	print(button)
	Poisoner_OnItemButtonClick(self, button);
end

-- This function creates/initialises the individual buttons for each poison
-- type. Note that we re-use buttons if they had been previously created, as
-- there is no delete operation for frames.
function Poisoner_CreateButtons()
--	Poisoner_SecureHandler:LoadMenu()
	local menu = PoisonerMenu;
	--[[
	local i = 0;
	Poisoner_Debug("Children of PoisonerMenu:")
	local children = { menu:GetChildren() };
	for _, child in ipairs(children) do
		Poisoner_Debug(child:GetName());
		i = i+1;
	end
	Poisoner_Debug(i.." children");
	]]
	local x
	x = POISONER_CONFIG.Menu.Spacing
	local firstButton = true
	local previousButton
	local buttonframewidth = 0
	for _, t in pairs(Poisoner_FindPoisons()) do
	--	local tname = string.gsub(t.name, " ", "_")
		local tname = t.shortname
		local buttonName = "PoisonerMenuButton__"..tname;
		local button = _G[buttonName];
		local securebuttonName = "PoisonerSecureButton__"..tname;
		local securebutton = _G[securebuttonName];
		if (not PoisonerStateHeader.inCombat) then
			if (button == nil) then
				
				button = CreateFrame("Button", buttonName, menu, "PoisonerItemButtonTemplate")
				button:SetHeight(36)
				button:SetWidth(36)
				button:ClearAllPoints();
				button:SetPoint("CENTER",UIParent,"CENTER");
				
				if _G["Poisoner_MenuOverlay"] then
					button:SetFrameLevel(Poisoner_MenuOverlay:GetFrameLevel()+1)
				else
					button:SetFrameLevel(menu:GetFrameLevel()+2)
				end
				
				button:RegisterForClicks("AnyDown");
				
				button.ShowTooltip = Poisoner_ShowTooltip--Poisoner_Tooltip(button,t.bag,t.bagslot,t.name)
				button.HideTooltip = Poisoner_HideTooltip
				button.PostClick = Poisoner_PostClick--Poisoner_OnItemButtonClick
				button.OnItemButtonUpdate = Poisoner_OnItemButtonUpdate
				
				local bfs = button:CreateFontString(buttonName.."Text","OVERLAY","GameFontNormal");
				bfs:SetPoint("BOTTOMRIGHT");
				bfs:SetTextColor(1,1,1,1);
				bfs:SetShadowColor(0,0,0,1);
				bfs:SetShadowOffset(-2,2);
				button:SetFontString(bfs);
				
				local icon = _G[buttonName.."Icon"];
				icon:SetTexture(t.icon);
				
				button.elapsed = 0;
				button.updateDelay = 2;
				button.needUpdate = false;
				button.Name = t.name
				button.Bag = t.bag
				button.Bagslot = t.bagslot
				
				button:SetAttribute("name", t.name);
				button:SetAttribute("type", "macro");
				button:SetAttribute("macrotext", "/use "..t.name.."\n/use [button:3] 18\n/click [button:3] "..securebuttonName.." MiddleButton\n/use [button:2] 17\n/click [button:2] "..securebuttonName.." RightButton\n/use [button:1] 16\n/click [button:1] "..securebuttonName.." LeftButton\n/click StaticPopup1Button1\n/click Poisoner_FreeButton MiddleButton");
				
			--	button:SetAttribute("_onshow", [[ print(self:GetName().." _onshow")]])
			--	button:SetAttribute("_onhide", [[ print(self:GetName().." _onhide")]])
				button:SetAttribute("_onenter", [=[
					--print(self:GetName().." _onenter")
					menu, psf = self:GetFrameRef("frame1"), self:GetFrameRef("PoisonSlotFrame");
					
					local som = psf:GetAttribute("showmouseover")
					
					if som then
						menu:Show();
					end
					
					control:CallMethod("ShowTooltip")
					
				]=])
				button:SetAttribute("_onleave", [=[
					--print(self:GetName().." _onleave")
					menu, psf = self:GetFrameRef("frame1"), self:GetFrameRef("PoisonSlotFrame");
					
					local som = psf:GetAttribute("showmouseover")
					
					if som then
						menu:Hide();
					end
					
					control:CallMethod("HideTooltip")
					
				]=])
				button:WrapScript(button, "PostClick", [=[
					control:CallMethod("PostClick", button)
					control:CallMethod("OnItemButtonUpdate", 1)
				]=])
				
				button:SetFrameRef("frame1", PoisonerMenu);
				button:SetFrameRef("PoisonSlotFrame", Poisoner_PoisonSlotFrame);
				
				--Masque/ButtonFacade
				if MSQ and Poisoner_Masque_Initiated == true then
					--Poisoner_Masque_Init()
					--print(button:GetName())
					local msqbtnGroup = MSQ:Group("Poisoner", "Menu Buttons")
					msqbtnGroup:AddButton(button)
					msqbtnGroup:ReSkin()
				end				
				
			end
			if (securebutton == nil) then
				
				securebutton = CreateFrame("BUTTON", securebuttonName, UIParent, "SecureHandlerClickTemplate, SecureHandlerBaseTemplate");
				securebutton:ClearAllPoints();
				securebutton:SetPoint("BOTTOMLEFT",PoisonerStateHeader,"TOPRIGHT");
				
				securebutton:SetAttribute("_onclick", [=[
					local left, right, middle, fb, psf = button == "LeftButton", button == "RightButton", button == "MiddleButton", self:GetFrameRef("FreeButton"), self:GetFrameRef("PoisonSlotFrame");
					local shift, ctrl, alt = IsShiftKeyDown(), IsControlKeyDown(), IsAltKeyDown();
					
					local poison = self:GetAttribute("name")
					--print(self:GetName().." _onclick")
					--print("Poison: "..poison)
					
					if left then
						if (not shift and not ctrl and not alt) then
							--print("Left Click")
							psf:SetAttribute("Text1", poison)
						elseif shift then
							--print("Left Shift Click")
							psf:SetAttribute("Text2", poison)
						elseif ctrl then
							--print("Left Ctrl Click")
							psf:SetAttribute("Text3", poison)
						elseif alt then
							--print("Left Alt Click")
							psf:SetAttribute("Text4", poison)
						end
					elseif right then
						if (not shift and not ctrl and not alt) then
							--print("Right Click")
							psf:SetAttribute("Text5", poison)
						elseif shift then
							--print("Right Shift Click")
							psf:SetAttribute("Text6", poison)
						elseif ctrl then
							print("Right Ctrl Click")
							psf:SetAttribute("Text7", poison)
						elseif alt then
							--print("Right Alt Click")
							psf:SetAttribute("Text8", poison)
						end
					elseif middle then
						if (not shift and not ctrl and not alt) then
							--print("Middle Click")
							psf:SetAttribute("Text9", poison)
						elseif shift then
							--print("Middle Shift Click")
							psf:SetAttribute("Text10", poison)
						elseif ctrl then
							--print("Middle Ctrl Click")
							psf:SetAttribute("Text11", poison)
						elseif alt then
							--print("Middle Alt Click")
							psf:SetAttribute("Text12", poison)
						end
					end					
										
				]=]);
				
				securebutton:RegisterForClicks("AnyDown");
				securebutton:SetAttribute("name", t.name);
				securebutton:SetFrameRef("FreeButton", Poisoner_FreeButton);
				securebutton:SetFrameRef("PoisonSlotFrame", Poisoner_PoisonSlotFrame);
				
			end
			button:Hide();
			button:ClearAllPoints();			
			if (t.quantity and t.quantity>0) then
				button.Name = t.name
				button.Bag = t.bag
				button.Bagslot = t.bagslot
				
			--	Poisoner_AnchorButton(button, previousButton)
			--	previousButton = button;
				buttonframewidth = buttonframewidth + POISONER_CONFIG.Menu.Spacing + button:GetWidth()
				button:Show();
			else
				--	print("Button hidden: "..button:GetName()) --debug
			end
			button.needUpdate = true;
		end
	end
	if (POISONER_CONFIG.Menu.Position == "top") or (POISONER_CONFIG.Menu.Position == "bottom") then
		PoisonerMenu:SetWidth(36)
		PoisonerMenu:SetHeight(buttonframewidth)
	else
		PoisonerMenu:SetWidth(buttonframewidth)
		PoisonerMenu:SetHeight(36)
	end
	Poisoner_SortButtons()
	
	Poisoner_SecureHandler:LoadMenu()
	
	--[[local testbuttonName = PoisonerTestButton;
	if (testbutton == nil) then
	testbutton = CreateFrame("Button", "PoisonerTestButton", menu, "PoisonerItemButtonTemplate2");

				testbutton:SetNormalTexture("Interface\\Icons\\Spell_Nature_Reincarnation");
				testbutton:SetHighlightTexture("Interface\\Icons\\Spell_Nature_Reincarnation");
				testbutton:GetNormalTexture():SetVertexColor(1,1,1,1);
				testbutton:GetHighlightTexture():SetVertexColor(0.5,0.5,1,1);

				testbutton:SetAttribute("type", "macro");
				testbutton:SetAttribute("macrotext", "/use Sofort wirkendes Gift IX\n/use [button:2] 17\n/use [button:1] 16\n/click StaticPopup1Button1\n/say Poisoner TEST");
				
			--testbutton:Hide();
			testbutton:ClearAllPoints();
			testbutton:Show();
			if (POISONER_CONFIG.Menu.Position == "right") then
				testbutton:SetPoint("TOPLEFT", x, 0);
				x = x + button:GetWidth() + 4;
			else
				testbutton:SetPoint("TOPRIGHT", x, 0);
				x = x - button:GetWidth() - 4;
			end
			testbutton:Show();
	
	end
	]]
end


function Poisoner_SortButtons()
	if PoisonerStateHeader.inCombat then PoisonerStateHeader.needUpdate = true; return end

	local prevbutton = nil
	
--	for k,v in ipairs(POISONER_CONFIG.Menu.Sorting) do
	for i = 1, #POISONER_CONFIG.Menu.Sorting do
		local v = POISONER_CONFIG.Menu.Sorting[i]
	--	print(k,v)
		
	--	local tname = string.gsub(v, " ", "_")
		local tname = v
		local buttonName = "PoisonerMenuButton__"..tname;
		local button = _G[buttonName];
		
		if button and button:IsShown() then
			Poisoner_AnchorButton(button, prevbutton)
			prevbutton = button
		end
		
	end
	
end

function Poisoner_AnchorButton(button, previousButton)
	
	local x = POISONER_CONFIG.Menu.Spacing
	local firstButton
	if not previousButton or previousButton == nil then firstButton = true end
	
	if (POISONER_CONFIG.Menu.Position == "top") then
		local ofsy = x
		if firstButton then
			button:SetPoint("BOTTOM", 0, ofsy);
			firstButton = false;
		else
			button:SetPoint("BOTTOM", previousButton, "TOP", 0, ofsy);
		end
	elseif (POISONER_CONFIG.Menu.Position == "bottom") then
		local ofsy = x*-1
		if firstButton then
			button:SetPoint("TOP", 0, ofsy);
			firstButton = false;
		else
			button:SetPoint("TOP", previousButton, "BOTTOM", 0, ofsy);
		end
	elseif (POISONER_CONFIG.Menu.Position == "right") or (POISONER_CONFIG.Menu.Position == "bottomright") or (POISONER_CONFIG.Menu.Position == "topright") then
		local ofsx = x
		if firstButton then
			button:SetPoint("TOPLEFT", ofsx, 0);
			firstButton = false;
		else
			button:SetPoint("TOPLEFT", previousButton, "TOPRIGHT", ofsx, 0);
		end
	else
		local ofsx = -x
		if firstButton then
			button:SetPoint("TOPRIGHT", ofsx, 0);
			firstButton = false;
		else
			button:SetPoint("TOPRIGHT", previousButton, "TOPLEFT", ofsx, 0);
		end
	end
	
end


--
-- Find available poisons
-- Returns an table keyed by poison name, value a table containing texture and quantity
--
function Poisoner_FindPoisons()
	local itemId, --[[itemLink,]] bagSlots, bagId, icon, quantity;
	local ret = {}
	for i=0, 4 do
		bagSlots = GetContainerNumSlots(i)
		if (bagSlots > 0) then
			for j=1, bagSlots do
				itemId = GetContainerItemID(i, j)
				icon, quantity = GetContainerItemInfo(i, j)
				if Poisoner_Patterns[itemId] then
					--local itemName, itemRank
					
					local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture, itemSellPrice = GetItemInfo(itemId)
					
					if (itemName ~= nil) then
						-- if the quantity is 1, we either have a single consumable item, or an expendable item
						if (quantity == 1) then
							local charges = Poisoner_CountCharges(i, j)
							if (charges ~= nil) then
								quantity = charges
							end
						end

						local t = ret[itemName];
						if (t == nil) then
							t = { name=itemName, icon=icon, quantity=0, --[[rank=itemRank,]] id=itemId, bag=i, bagslot=j, shortname=Poisoner_Patterns[itemId] }
							ret[itemName] = t
						end
						t.quantity = t.quantity + quantity
						Poisoner_PoisonsEverSeen[itemName] = {}
						Poisoner_PoisonsEverSeen[itemName].icon = icon
						Poisoner_PoisonsEverSeen[itemName].shortname = Poisoner_Patterns[itemId]
					end
				end
			end
		end
	end
	-- include zero counts for previously seen items we no longer have
	for prevItemName, tble in pairs(Poisoner_PoisonsEverSeen) do
		local t = ret[prevItemName]
		if (t == nil) then
			t = { name=prevItemName, icon=tble.icon, quantity=0, bag=-1, bagslot=-1, shortname=tble.shortname }
			ret[prevItemName] = t
		end
	end
	return ret
end
-- since we cannot destroy frames, we must always remember everything we've seen
Poisoner_PoisonsEverSeen = {};

-- Use a tooltip to scan for the number of 'charges' on expendable items.
-- Returns the number of charges, or nil if it could not be found.
function Poisoner_CountCharges(bagId, bagSlot)
Poisoner_Debug("Looking for charges of "..bagId..","..bagSlot);
	local ret = nil;
	PoisonerScannerTooltip:SetOwner(UIParent, "ANCHOR_NONE");
	PoisonerScannerTooltip:SetBagItem(bagId, bagSlot);
	for i=1,PoisonerScannerTooltip:NumLines() do
		local field = _G["PoisonerScannerTooltipTextLeft"..i];
		if (field ~= nil) then
			local text = field:GetText();
			if (text) then
				local _, _, charges = string.find(text, POISONER_PATTERN_CHARGES);
				if (charges) then
					ret = tonumber(charges);
					break;
				end
			end
		end
	end
	PoisonerScannerTooltip:Hide();
	return ret;
end


--
-- Quick reapply button
--

function Poisoner_CheckQuickButton()
	if InCombatLockdown() then PoisonerStateHeader.needUpdate = true; return end
	
	if (POISONER_CONFIG.Enabled == 1) then
		if ((Poisoner_Poison16.Name ~= nil and Poisoner_Poison16.Name ~= "") and (Poisoner_Poison17.Name ~= nil and Poisoner_Poison17.Name ~= "") --[[and (Poisoner_Poison18.Name ~= nil and Poisoner_Poison18.Name ~= "")]]) then
			if (Poisoner_QuickButtonVisible == 0) then
				Poisoner_CreateQuickButton()
				--print("Poisoner CREATE QB")	--Debug
			elseif (Poisoner_QuickButtonVisible == 1) then
				Poisoner_UpdateQuickButton()
				--print("Poisoner UPDATE QB")	--Debug
			end
		elseif ((Poisoner_Poison16.Name == nil or Poisoner_Poison16.Name == "") and (Poisoner_Poison17.Name == nil or Poisoner_Poison17.Name == "") --[[and (Poisoner_Poison18.Name == nil or Poisoner_Poison18.Name == "")]]) then
			Poisoner_QuickButton:Hide();
		end
	elseif (POISONER_CONFIG.Enabled == 0) then
		Poisoner_QuickButton:Hide();
	end
	
end

function Poisoner_GetToolTipTexture()

	local CPName = POISONER_CONFIG.Poisons.CPName		--Verkrüppelndes Gift
	local MPName = POISONER_CONFIG.Poisons.MPName		--Gedankenbenebelndes Gift
	local DPName = POISONER_CONFIG.Poisons.DPName		--Tödliches Gift
	local IPName = POISONER_CONFIG.Poisons.IPName		--Sofort wirkendes Gift
	local WPName = POISONER_CONFIG.Poisons.WPName		--Wundgift
	
	local NoTexture = ""	--"Interface\\Icons\\INV_Misc_QuestionMark"
	local CPTexture = GetItemIcon(3775)
	local MPTexture = GetItemIcon(5237)
	local DPTexture = GetItemIcon(2892)
	local IPTexture = GetItemIcon(6947)
	local WPTexture = GetItemIcon(10918)

	Poisoner_PoisonSlots = {
		Poisoner_Poison16,
		Poisoner_Poison16_SHIFT,
		Poisoner_Poison16_CTRL,
		Poisoner_Poison16_ALT,
		Poisoner_Poison17,
		Poisoner_Poison17_SHIFT,
		Poisoner_Poison17_CTRL,
		Poisoner_Poison17_ALT,
		Poisoner_Poison18,
		Poisoner_Poison18_SHIFT,
		Poisoner_Poison18_CTRL,
		Poisoner_Poison18_ALT,
	}

	for k,v in pairs(Poisoner_PoisonSlots) do
		if v ~= nil then
			if (not v.Name) or (v.Name == nil) then
				v.Texture = NoTexture
				v.Name = ""
			elseif v.Name == CPName then
				v.Texture = CPTexture
			elseif v.Name == MPName then
				v.Texture = MPTexture
			elseif v.Name == DPName then
				v.Texture = DPTexture
			elseif v.Name == IPName then
				v.Texture = IPTexture
			elseif v.Name == WPName then
				v.Texture = WPTexture
			elseif v.Name == "" then
				v.Texture = NoTexture
			end
		else
			v.Texture = NoTexture
			v.Name = ""
		end
	end
	
end

function Poisoner_CreateQuickButton()

		--local btn = CreateFrame("Button", "Poisoner_QuickButton", UIParent, "PoisonerReapplyTemplate");
		local btn = Poisoner_QuickButton
		local icon = Poisoner_QuickButtonIcon
		
		btn:RegisterForClicks("LeftButtonDown", "RightButtonDown", "MiddleButtonDown");
		btn:SetNormalTexture("Interface\\Icons\\Ability_Creature_Poison_06");
		btn:SetHighlightTexture("Interface\\Icons\\Ability_Creature_Poison_06");
		btn:GetNormalTexture():SetVertexColor(1,1,1,1);
		btn:GetHighlightTexture():SetVertexColor(0.5,0.5,1,1);
		icon:SetTexture("Interface\\Icons\\Ability_Creature_Poison_06")
		
		Poisoner_GetToolTipTexture()
		
		btn:SetAttribute("type", "macro");
		--btn:SetAttribute("macrotext", "/use [button:3] "..Poisoner_Poison18.Name.."\n/use [button:3] 18\n/use [button:2] "..Poisoner_Poison17.Name.."\n/use [button:2] 17\n/use [button:1] "..Poisoner_Poison16.Name.."\n/use [button:1] 16\n/click StaticPopup1Button1");
		btn:SetAttribute("macrotext", "/use [nomodifier,button:3] "..Poisoner_Poison18.Name.."\n/use [modifier:shift,button:3] "..Poisoner_Poison18_SHIFT.Name.."\n/use [modifier:ctrl,button:3] "..Poisoner_Poison18_CTRL.Name.."\n/use [modifier:alt,button:3] "..Poisoner_Poison18_ALT.Name.."\n/use [button:3] 18\n/use [nomodifier,button:2] "..Poisoner_Poison17.Name.."\n/use [modifier:shift,button:2] "..Poisoner_Poison17_SHIFT.Name.."\n/use [modifier:ctrl,button:2] "..Poisoner_Poison17_CTRL.Name.."\n/use [modifier:alt,button:2] "..Poisoner_Poison17_ALT.Name.."\n/use [button:2] 17\n/use [nomodifier,button:1] "..Poisoner_Poison16.Name.."\n/use [modifier:shift,button:1] "..Poisoner_Poison16_SHIFT.Name.."\n/use [modifier:ctrl,button:1] "..Poisoner_Poison16_CTRL.Name.."\n/use [modifier:alt,button:1] "..Poisoner_Poison16_ALT.Name.."\n/use [button:1] 16\n/click StaticPopup1Button1\n/run PoisonerOptions_CheckPoisons()");
		
		btn:SetScript("OnEnter", function() Poisoner_QuickButton_Tooltip(btn) end);	
		btn:SetScript("OnLeave", function() GameTooltip:Hide() end);
		
		btn:ClearAllPoints();
		btn:SetPoint("CENTER", Poisoner_QuickButton_Overlay, "CENTER");
		btn:Show();
		Poisoner_QuickButtonVisible = 1;
	
		--Masque/ButtonFacade
		if MSQ and Poisoner_Masque_Initiated == true then
			--Poisoner_Masque_Init()
		--	print(btn:GetName())
			MSQ:Group("Poisoner", "QuickButton"):AddButton(btn)
			MSQ:Group("Poisoner", "QuickButton"):ReSkin()
		end
	
		print("|cff00ff00Poisoner:|r QuickButton created.")
	
	-- Tooltip layout
		
	local COLOR_GREEN = "|cff00ff00";
	local COLOR_GREY = "|cff808080";
	local COLOR_END = "|r";
		
	--Poisoner_QuickButton_Text = ""..COLOR_GREY..Poisoner_ToopTipTitle_CurrentPoisonSet..COLOR_END.."\n"..INVTYPE_WEAPONMAINHAND..": "..COLOR_GREEN..Poisoner_Poison16.Name..COLOR_END.."\n"..INVTYPE_WEAPONOFFHAND..": "..COLOR_GREEN..Poisoner_Poison17.Name..COLOR_END.."\n"..INVTYPE_THROWN..": "..COLOR_GREEN..Poisoner_Poison18.Name..COLOR_END..""
	
	Poisoner_QuickButton_Text_MH = "|T"..Poisoner_Poison16.Texture..":0|t |T"..Poisoner_Poison16_SHIFT.Texture..":0|t |T"..Poisoner_Poison16_CTRL.Texture..":0|t |T"..Poisoner_Poison16_ALT.Texture..":0|t"
	Poisoner_QuickButton_Text_OH = "|T"..Poisoner_Poison17.Texture..":0|t |T"..Poisoner_Poison17_SHIFT.Texture..":0|t |T"..Poisoner_Poison17_CTRL.Texture..":0|t |T"..Poisoner_Poison17_ALT.Texture..":0|t"
	Poisoner_QuickButton_Text_TW = "|T"..Poisoner_Poison18.Texture..":0|t |T"..Poisoner_Poison18_SHIFT.Texture..":0|t |T"..Poisoner_Poison18_CTRL.Texture..":0|t |T"..Poisoner_Poison18_ALT.Texture..":0|t"
	
	Poisoner_QuickButton_Text_Slots = ""..INVTYPE_WEAPONMAINHAND..": \n"..INVTYPE_WEAPONOFFHAND..": \n"..INVTYPE_THROWN..": "
	Poisoner_QuickButton_Text_Textures = ""..Poisoner_QuickButton_Text_MH.."\n"..Poisoner_QuickButton_Text_OH.."\n"..Poisoner_QuickButton_Text_TW..""
	
	Poisoner_QuickButton:Show();
		
end

function Poisoner_UpdateQuickButton()
	local btn = Poisoner_QuickButton
	local icon = Poisoner_QuickButtonIcon
	
	--Masque/ButtonFacade
		if MSQ and Poisoner_Masque_Initiated == true then
			--Poisoner_Masque_Init()
		--	print(btn:GetName())
			MSQ:Group("Poisoner", "QuickButton"):AddButton(btn)
			MSQ:Group("Poisoner", "QuickButton"):ReSkin()
		end
	
	btn:SetAttribute("type", "macro");
	--btn:SetAttribute("macrotext", "/use [button:3] "..Poisoner_Poison18.Name.."\n/use [button:3] 18\n/use [button:2] "..Poisoner_Poison17.Name.."\n/use [button:2] 17\n/use [button:1] "..Poisoner_Poison16.Name.."\n/use [button:1] 16\n/click StaticPopup1Button1");
	btn:SetAttribute("macrotext", "/use [nomodifier,button:3] "..Poisoner_Poison18.Name.."\n/use [modifier:shift,button:3] "..Poisoner_Poison18_SHIFT.Name.."\n/use [modifier:ctrl,button:3] "..Poisoner_Poison18_CTRL.Name.."\n/use [modifier:alt,button:3] "..Poisoner_Poison18_ALT.Name.."\n/use [button:3] 18\n/use [nomodifier,button:2] "..Poisoner_Poison17.Name.."\n/use [modifier:shift,button:2] "..Poisoner_Poison17_SHIFT.Name.."\n/use [modifier:ctrl,button:2] "..Poisoner_Poison17_CTRL.Name.."\n/use [modifier:alt,button:2] "..Poisoner_Poison17_ALT.Name.."\n/use [button:2] 17\n/use [nomodifier,button:1] "..Poisoner_Poison16.Name.."\n/use [modifier:shift,button:1] "..Poisoner_Poison16_SHIFT.Name.."\n/use [modifier:ctrl,button:1] "..Poisoner_Poison16_CTRL.Name.."\n/use [modifier:alt,button:1] "..Poisoner_Poison16_ALT.Name.."\n/use [button:1] 16\n/click StaticPopup1Button1\n/run PoisonerOptions_CheckPoisons()");
		
	Poisoner_GetToolTipTexture()
	
	-- Tooltip layout
		
	local COLOR_GREEN = "|cff00ff00";
	local COLOR_GREY = "|cff808080";
	local COLOR_END = "|r";
		
	--Poisoner_QuickButton_Text = ""..COLOR_GREY..Poisoner_ToopTipTitle_CurrentPoisonSet..COLOR_END.."\n"..INVTYPE_WEAPONMAINHAND..": "..COLOR_GREEN..Poisoner_Poison16.Name..COLOR_END.."\n"..INVTYPE_WEAPONOFFHAND..": "..COLOR_GREEN..Poisoner_Poison17.Name..COLOR_END.."\n"..INVTYPE_THROWN..": "..COLOR_GREEN..Poisoner_Poison18.Name..COLOR_END..""
	
	Poisoner_QuickButton_Text_MH = "|T"..Poisoner_Poison16.Texture..":0|t |T"..Poisoner_Poison16_SHIFT.Texture..":0|t |T"..Poisoner_Poison16_CTRL.Texture..":0|t |T"..Poisoner_Poison16_ALT.Texture..":0|t "
	Poisoner_QuickButton_Text_OH = "|T"..Poisoner_Poison17.Texture..":0|t |T"..Poisoner_Poison17_SHIFT.Texture..":0|t |T"..Poisoner_Poison17_CTRL.Texture..":0|t |T"..Poisoner_Poison17_ALT.Texture..":0|t "
	Poisoner_QuickButton_Text_TW = "|T"..Poisoner_Poison18.Texture..":0|t |T"..Poisoner_Poison18_SHIFT.Texture..":0|t |T"..Poisoner_Poison18_CTRL.Texture..":0|t |T"..Poisoner_Poison18_ALT.Texture..":0|t "
	
	Poisoner_QuickButton_Text_Slots = ""..INVTYPE_WEAPONMAINHAND..": \n"..INVTYPE_WEAPONOFFHAND..": \n"..INVTYPE_THROWN..": "
	Poisoner_QuickButton_Text_Textures = ""..Poisoner_QuickButton_Text_MH.."\n"..Poisoner_QuickButton_Text_OH.."\n"..Poisoner_QuickButton_Text_TW..""
	
	Poisoner_QuickButton:Show();
end


--
-- Slash command processing
--
function Poisoner_ProcessCommand(msg)
	local cmd, param1 = Poisoner_ParamParser(msg);
	local subcmd1, param2 = Poisoner_ParamParser(param1);
	local subcmd2, param3 = Poisoner_ParamParser(param2);
	local subcmd3 = Poisoner_ParamParser(param3);
--[[
	if cmd == nil then cmd = "cmd" end
	if param1 == nil then param1 = "param1" end
	if param2 == nil then param2 = "param2" end
	if param3 == nil then param3 = "param3" end
	if subcmd1 == nil then subcmd1 = "subcmd1" end
	if subcmd2 == nil then subcmd2 = "subcmd2" end
	if subcmd3 == nil then subcmd3 = "subcmd3" end
	print("Poisoner >"..cmd.."< >"..param1.."<")
	print(">"..subcmd1.."< >"..subcmd2.."< >"..subcmd3.."<")
]]
	--Poisoner main
	if (cmd == "") then
		PoisonerOptions_ToggleSettings();
	elseif (cmd == "enable") then
		Poisoner_Enable();
	elseif (cmd == "disable") then
		Poisoner_Disable();
	elseif (cmd == "config") then
		PoisonerOptions_ToggleSettings();
	elseif (cmd == "quickbutton") then
		local msg = "qb "..param1
		Poisoner_ProcessCommand(msg)
	--FreeButton
	elseif (cmd:lower() == "freebutton") or (string.match(cmd:lower(), "fb")) then
		if (string.match(subcmd1:lower(), "enable")) then
			POISONER_CONFIG.Buttons.FreeButton.Active = 1;
			Poisoner_FreeButton:Show();
		elseif (string.match(subcmd1:lower(), "disable")) then
			POISONER_CONFIG.Buttons.FreeButton.Active = 0;
			Poisoner_FreeButton:Hide();
		elseif (string.match(subcmd1:lower(), "lock")) then
			Poisoner_DragLock();
		elseif (string.match(subcmd1:lower(), "unlock")) then
			Poisoner_DragUnlock();
		elseif (string.match(subcmd1:lower(), "reset")) then
			Poisoner_DragReset();
		elseif (string.match(subcmd1:lower(), "scale")) then
			if ( (subcmd2 ~=nil) and (tonumber(subcmd2) ~= nil) and tonumber(subcmd2) >=0.1 and tonumber(subcmd2)<=2 ) then
				local arg = tonumber(subcmd2);
				Poisoner_FreeButton:SetScale(arg);
				POISONER_CONFIG.Buttons.FreeButton.Scale = arg;
			end
		elseif (string.match(subcmd1:lower(), "alpha")) then
			if ( (subcmd2 ~=nil) and (tonumber(subcmd2) ~= nil) and tonumber(subcmd2) >=0.1 and tonumber(subcmd2)<=1 ) then
				local arg = tonumber(subcmd2);
				Poisoner_FreeButton:SetAlpha(arg);
				POISONER_CONFIG.Buttons.FreeButton.Alpha = arg;
			end
		end
	--Menu
	elseif (string.match(cmd:lower(), "menu")) then
		--parent
		if (string.match(subcmd1:lower(), "parent")) then
			if (string.match(subcmd2:lower(), "own")) or (string.match(param2:lower(), "own frame")) then
				POISONER_CONFIG.Menu.Parent = "Poisoner_FreeButton";
				Poisoner_SetPosition()
				--print("|cff00ff00Poisoner|r: "..OPTION_RESTART_REQUIREMENT.."")
				--StaticPopup_Show("POISONER_STARTED_ONCE");
			elseif (string.match(subcmd2:lower(), "minimap")) then
				POISONER_CONFIG.Menu.Parent = "Minimap";
				Poisoner_SetPosition()
				--print("|cff00ff00Poisoner|r: "..OPTION_RESTART_REQUIREMENT.."")
				--StaticPopup_Show("POISONER_STARTED_ONCE");
			end
		--position
		elseif (string.match(subcmd1:lower(), "position")) then
			if (string.match(subcmd2:lower(), "top")) then
				POISONER_CONFIG.Menu.Position = "top";
				Poisoner_SetPosition("top")
			elseif (string.match(subcmd2:lower(), "topleft")) then
				POISONER_CONFIG.Menu.Position = "topleft";
				Poisoner_SetPosition("topleft")
			elseif (string.match(subcmd2:lower(), "topright")) then
				POISONER_CONFIG.Menu.Position = "topright";
				Poisoner_SetPosition("topright")
			elseif (string.match(subcmd2:lower(), "left")) then
				POISONER_CONFIG.Menu.Position = "left";
				Poisoner_SetPosition("left")
			elseif (string.match(subcmd2:lower(), "right")) then
				POISONER_CONFIG.Menu.Position = "right";
				Poisoner_SetPosition("right")
			elseif (string.match(subcmd2:lower(), "bottom")) then
				POISONER_CONFIG.Menu.Position = "bottom";
				Poisoner_SetPosition("bottom")
			elseif (string.match(subcmd2:lower(), "bottomleft")) then
				POISONER_CONFIG.Menu.Position = "bottomleft";
				Poisoner_SetPosition("bottomleft")
			elseif (string.match(subcmd2:lower(), "bottomright")) then
				POISONER_CONFIG.Menu.Position = "bottomright";
				Poisoner_SetPosition("bottomright")
			end
		--scale
		elseif (string.match(subcmd1:lower(), "scale")) then
			if ( (subcmd2 ~=nil) and (tonumber(subcmd2) ~= nil) and tonumber(subcmd2) >=0.1 and tonumber(subcmd2)<=2 ) then
				local arg = string.match(subcmd2, "([%d%.]+)");
				Poisoner_SetScale(tonumber(subcmd2))
			end
		--Overwrite Presets
		elseif (string.match(subcmd1:lower(), "overwrite")) then
			if (string.match(subcmd2:lower(), "true")) or ( tonumber(subcmd2) == 1 ) then
				POISONER_CONFIG.Preset.Overwrite = 1;
			elseif (string.match(subcmd2:lower(), "false")) or ( tonumber(subcmd2) == 0 ) then
				POISONER_CONFIG.Preset.Overwrite = 0;
			end
		--reset
		elseif (string.match(subcmd1:lower(), "reset")) then
			Poisoner_SetScale(1.0);
			Poisoner_SetPosition("left");
		end
	--ToolTip
	elseif (string.match(cmd:lower(), "tooltip")) then
		if (string.match(subcmd1:lower(), "full")) then
			POISONER_CONFIG.TooltipType = "full";
		elseif (string.match(subcmd1:lower(), "name")) then
			POISONER_CONFIG.TooltipType = "name";
		end
	elseif (string.match(cmd:lower(), "tt")) then
		if (string.match(subcmd1:lower(), "full")) then
			POISONER_CONFIG.TooltipType = "full";
		elseif (string.match(subcmd1:lower(), "name")) then
			POISONER_CONFIG.TooltipType = "name";
		end
	--Post Poison
	elseif (string.match(cmd:lower(), "postpoison")) then
		if (string.match(subcmd1:lower(), "true")) or ( tonumber(subcmd1) == 1 ) then
			POISONER_CONFIG.PrintClickedPoison = 1;
		elseif (string.match(subcmd1:lower(), "false")) or ( tonumber(subcmd1) == 0 ) then
			POISONER_CONFIG.PrintClickedPoison = 0;
		end
	--Timer
	elseif (string.match(cmd:lower(), "timer")) then
		if (string.match(subcmd1:lower(), "enable")) then
			POISONER_CONFIG.Timer.Active = 1;
			PoisonerOptions_CallUpdate();
		elseif (string.match(subcmd1:lower(), "disable")) then
			POISONER_CONFIG.Timer.Active = 0;
		elseif (string.match(subcmd1:lower(), "warningthreshold")) or (string.match(subcmd1:lower(), "wt")) then
			if ( (subcmd2 ~=nil) and (tonumber(subcmd2) ~= nil) and tonumber(subcmd2) >=1 and tonumber(subcmd2)<=25 ) then
				local arg = string.match(subcmd2, "([%d%.]+)");
				Poisoner_WarningThreshold = tonumber(subcmd2);
				POISONER_CONFIG.Timer.WarningThreshold = tonumber(subcmd2);
			else
				Poisoner_WarningThreshold = 5;
				POISONER_CONFIG.Timer.WarningThreshold = 5;
			end
		--output
		elseif (string.match(subcmd1:lower(), "output")) then
			if (string.match(subcmd2:lower(), "audio")) then
				if (string.match(subcmd3:lower(), "1")) or (string.match(subcmd3:lower(), "true")) then
					POISONER_CONFIG.Timer.Output.Audio = 1;
					PoisonerOptions_CallUpdate();
				elseif (string.match(subcmd3:lower(), "0")) or (string.match(subcmd3:lower(), "false")) then
					POISONER_CONFIG.Timer.Output.Audio = 0;
				end
			elseif (string.match(subcmd2:lower(), "chat")) then
				if (string.match(subcmd3:lower(), "1")) or (string.match(subcmd3:lower(), "true")) then
					POISONER_CONFIG.Timer.Output.Chat = 1;
					PoisonerOptions_CallUpdate();
				elseif (string.match(subcmd3:lower(), "0")) or (string.match(subcmd3:lower(), "false")) then
					POISONER_CONFIG.Timer.Output.Chat = 0;
				end
			elseif (string.match(subcmd2:lower(), "errorframe")) or (string.match(subcmd2:lower(), "error")) then
				if (string.match(subcmd3:lower(), "1")) or (string.match(subcmd3:lower(), "true")) then
					POISONER_CONFIG.Timer.Output.ErrorFrame = 1;
					PoisonerOptions_CallUpdate();
				elseif (string.match(subcmd3:lower(), "0")) or (string.match(subcmd3:lower(), "false")) then
					POISONER_CONFIG.Timer.Output.ErrorFrame = 0;
				end
			elseif (string.match(subcmd2:lower(), "aura")) then
				if (string.match(subcmd3:lower(), "1")) or (string.match(subcmd3:lower(), "true")) then
					POISONER_CONFIG.Timer.Output.Aura = 1;
					PoisonerOptions_CallUpdate();
				elseif (string.match(subcmd3:lower(), "0")) or (string.match(subcmd3:lower(), "false")) then
					POISONER_CONFIG.Timer.Output.Aura = 0;
					PoisonerTimer_Mainhand:Hide();
					PoisonerTimer_Offhand:Hide();
					PoisonerTimer_Throwweapon:Hide();
				end
			elseif (string.match(subcmd2:lower(), "mainhand") or string.match(subcmd2:lower(), "mh")) then
				if (string.match(subcmd3:lower(), "1")) or (string.match(subcmd3:lower(), "true")) then
					POISONER_CONFIG.Timer.Weapon.MainHand = 1;
					Poisoner_NoPoison_Warning1 = false
					Poisoner_MinWarning1 = false
				elseif (string.match(subcmd3:lower(), "0")) or (string.match(subcmd3:lower(), "false")) then
					POISONER_CONFIG.Timer.Weapon.MainHand = 0;
					PoisonerTimer_Mainhand:Hide();
				end
			elseif (string.match(subcmd2:lower(), "offhand") or string.match(subcmd2:lower(), "oh")) then
				if (string.match(subcmd3:lower(), "1")) or (string.match(subcmd3:lower(), "true")) then
					POISONER_CONFIG.Timer.Weapon.OffHand = 1;
					Poisoner_NoPoison_Warning2 = false
					Poisoner_MinWarning2 = false
				elseif (string.match(subcmd3:lower(), "0")) or (string.match(subcmd3:lower(), "false")) then
					POISONER_CONFIG.Timer.Weapon.OffHand = 0;
					PoisonerTimer_Offhand:Hide();
				end
			elseif (string.match(subcmd2:lower(), "throwweapon") or string.match(subcmd2:lower(), "tw")) then
				if (string.match(subcmd3:lower(), "1")) or (string.match(subcmd3:lower(), "true")) then
					POISONER_CONFIG.Timer.Weapon.ThrowWeapon = 1;
					Poisoner_NoPoison_Warning3 = false
					Poisoner_MinWarning3 = false
				elseif (string.match(subcmd3:lower(), "0")) or (string.match(subcmd3:lower(), "false")) then
					POISONER_CONFIG.Timer.Weapon.ThrowWeapon = 0;
					PoisonerTimer_Throwweapon:Hide();
				end
			end
		--aura options
		elseif (string.match(subcmd1:lower(), "aura")) then
			if (string.match(subcmd2:lower(), "lock")) then
				POISONER_CONFIG.Timer.Lock = 1;
				PoisonerTimer_UpdateLock();
			elseif (string.match(subcmd2:lower(), "unlock")) then
				POISONER_CONFIG.Timer.Lock = 0;
				PoisonerTimer_UpdateLock();
			elseif (string.match(subcmd2:lower(), "scale")) then
				if ( (subcmd3 ~=nil) and (tonumber(subcmd3) ~= nil) and tonumber(subcmd3) >=0.1 and tonumber(subcmd3)<=2 ) then
					local arg = string.match(subcmd3, "([%d%.]+)");
					PoisonerTimer_IconFrameScale = tonumber(subcmd3);
					PoisonerTimer_IconFrame:SetScale(PoisonerTimer_IconFrameScale);
					POISONER_CONFIG.Timer.Scale = PoisonerTimer_IconFrameScale;
					PoisonerOptions_CallUpdate();
				end
			elseif (string.match(subcmd2:lower(), "alpha")) then
				if ( (subcmd3 ~=nil) and (tonumber(subcmd3) ~= nil) and tonumber(subcmd3) >=0.1 and tonumber(subcmd3)<=1 ) then
					local arg = string.match(subcmd3, "([%d%.]+)");
					PoisonerTimer_IconFrameAlpha = tonumber(subcmd3);
					PoisonerTimer_IconFrame:SetAlpha(PoisonerTimer_IconFrameAlpha);
					POISONER_CONFIG.Timer.Alpha = PoisonerTimer_IconFrameAlpha;
					PoisonerOptions_CallUpdate();
				end
			end
		end
	--AutoBuy
	elseif (string.match(cmd:lower(), "autobuy")) then
		if (string.match(subcmd1:lower(), "enable")) then
			POISONER_CONFIG.Buy.Active = 1;
		elseif (string.match(subcmd1:lower(), "disable")) then
			POISONER_CONFIG.Buy.Active = 0;
		elseif (string.match(subcmd1:lower(), "confirm")) then
			POISONER_CONFIG.Buy.Prompt = 0;
		elseif (string.match(subcmd1:lower(), "auto")) then
			POISONER_CONFIG.Buy.Prompt = 1;
		elseif (string.match(subcmd1:lower(), "check")) then
			if (subcmd2 == "true") or ( tonumber(subcmd2) == 1 ) then
				POISONER_CONFIG.Buy.Check = 1;
			elseif (subcmd2 == "false") or ( tonumber(subcmd2) == 0 ) then
				POISONER_CONFIG.Buy.Check = 0;
			end
		elseif (string.match(subcmd1:lower(), "cp")) then
			if ( (subcmd2 ~=nil) and (tonumber(subcmd2) ~= nil) and tonumber(subcmd2) >=0 and tonumber(subcmd2)<=100 ) then
				local arg = string.match(subcmd2, "([%d%.]+)");
				POISONER_CONFIG.Buy.CP = tonumber(subcmd2);
			end
		elseif (string.match(subcmd1:lower(), "dp")) then
			if ( (subcmd2 ~=nil) and (tonumber(subcmd2) ~= nil) and tonumber(subcmd2) >=0 and tonumber(subcmd2)<=100 ) then
				local arg = string.match(subcmd2, "([%d%.]+)");
				POISONER_CONFIG.Buy.DP = tonumber(subcmd2);
			end
		elseif (string.match(subcmd1:lower(), "ip")) then
			if ( (subcmd2 ~=nil) and (tonumber(subcmd2) ~= nil) and tonumber(subcmd2) >=0 and tonumber(subcmd2)<=100 ) then
				local arg = string.match(subcmd2, "([%d%.]+)");
				POISONER_CONFIG.Buy.IP = tonumber(subcmd2);
			end
		elseif (string.match(subcmd1:lower(), "mp")) then
			if ( (subcmd2 ~=nil) and (tonumber(subcmd2) ~= nil) and tonumber(subcmd2) >=0 and tonumber(subcmd2)<=100 ) then
				local arg = string.match(subcmd2, "([%d%.]+)");
				POISONER_CONFIG.Buy.MP = tonumber(subcmd2);
			end
		elseif (string.match(subcmd1:lower(), "wp")) then
			if ( (subcmd2 ~=nil) and (tonumber(subcmd2) ~= nil) and tonumber(subcmd2) >=0 and tonumber(subcmd2)<=100 ) then
				local arg = string.match(subcmd2, "([%d%.]+)");
				POISONER_CONFIG.Buy.WP = tonumber(subcmd2);
			end
		end
	--Presets
	elseif (string.match(cmd:lower(), "presets")) then
		if (string.match(subcmd1:lower(), "reset")) then
			PoisonerOptions_ResetPresets()
		end
	--QuickButton
	elseif (string.match(cmd:lower(), "qb")) then
		if (subcmd1:lower() == "lock") then
			POISONER_CONFIG.Buttons.QuickButton.Lock = 1;
			Poisoner_QuickButton_UpdateLock();
		elseif (subcmd1:lower() == "unlock") then
			POISONER_CONFIG.Buttons.QuickButton.Lock = 0;
			Poisoner_QuickButton_UpdateLock();
		elseif (string.match(subcmd1:lower(), "reset")) then
			Poisoner_QuickButton_Reset();
		elseif (string.match(subcmd1:lower(), "alpha")) then
			if ( (subcmd2 ~=nil) and (tonumber(subcmd2) ~= nil) and tonumber(subcmd2) >=0.1 and tonumber(subcmd2)<=1 ) then
				local arg = string.match(subcmd2, "([%d%.]+)");
				POISONER_CONFIG.Buttons.QuickButton.Alpha = tonumber(subcmd2);
				Poisoner_QuickButton_Overlay:SetAlpha(tonumber(subcmd2));
			end
		elseif (string.match(subcmd1:lower(), "scale")) then
			if ( (subcmd2 ~=nil) and (tonumber(subcmd2) ~= nil) and tonumber(subcmd2) >=0.1 and tonumber(subcmd2)<=2 ) then
				local arg = string.match(subcmd2, "([%d%.]+)");
				POISONER_CONFIG.Buttons.QuickButton.Scale = tonumber(subcmd2);
				Poisoner_QuickButton_Overlay:SetScale(tonumber(subcmd2));
			end
		end
	--Thanks
	elseif (string.match(cmd:lower(), "thanks")) then
		Poisoner_Thanks()
	--else
	else
		DEFAULT_CHAT_FRAME:AddMessage(POISONER_COMMANDERROR..cmd, 1.0, 1.0, 0.5);
	end
	PoisonerOptions_LoadSettings()
end

function Poisoner_ParamParser(msg)
	if msg then
 		local a,b,c=strfind(msg, "(%S+)"); --contiguous string of non-space characters
 		if a then
 			return c, strsub(msg, b+2);
 		else	
 			return "";
 		end
 	end
end

function Poisoner_Disable()
	--print(""..POISONER_TITLE..": "..DISABLE.."...")	--Debug
	POISONER_CONFIG.Enabled = 0;
	--if (PoisonerMenu:IsShown()) then
		PoisonerMenu:Hide();
	--end
	Poisoner_FreeButton:Hide();
	Poisoner_QuickButton:Hide();
end

function Poisoner_Enable()
	POISONER_CONFIG.Enabled = 1;
	Poisoner_FreeButton:Show();
	if (POISONER_CONFIG.StartedOnce == 0) then
		StaticPopup_Show("POISONER_STARTED_ONCE");
	end
	Poisoner_CheckQuickButton()
end

function PoisonerMenu_Toggle()
	local menu = PoisonerMenu;
	if (PoisonerMenu:IsShown()) then
		PoisonerMenu:Hide();
	else
		--[[local parent = POISONER_CONFIG.Menu.Parent
		local parentFrame
		local position = POISONER_CONFIG.Menu.Position
		local p, rp;
		if (position == "top") then
			menu:SetWidth("36");
			menu:SetHeight("240");
			p = "BOTTOM";
			rp = "TOP";
		elseif (position == "topleft") then
			menu:SetWidth("240");
			menu:SetHeight("36");
			p = "BOTTOMRIGHT";
			rp = "TOPLEFT";
		elseif (position == "topright") then
			menu:SetWidth("240");
			menu:SetHeight("36");
			p = "BOTTOMLEFT";
			rp = "TOPRIGHT";
		elseif (position == "left") then
			menu:SetWidth("240");
			menu:SetHeight("36");
			p = "RIGHT";
			rp = "LEFT";
		elseif (position == "right") then
			menu:SetWidth("240");
			menu:SetHeight("36");
			p = "LEFT";
			rp = "RIGHT";		
		elseif (position == "bottom") then
			menu:SetWidth("36");
			menu:SetHeight("240");
			p = "TOP";
			rp = "BOTTOM";
		elseif (position == "bottomleft") then
			menu:SetWidth("240");
			menu:SetHeight("36");
			p = "TOPRIGHT";
			rp = "BOTTOMLEFT";
		elseif (position == "bottomright") then
			menu:SetWidth("240");
			menu:SetHeight("36");
			p = "TOPLEFT";
			rp = "BOTTOMRIGHT";
		else
			menu:SetWidth("240");
			menu:SetHeight("36");
			p = "TOPRIGHT";
			rp = "LEFT";
		end
		PoisonerMenu:ClearAllPoints()
		if ((parent == "Minimap") and (LibDBIcon10_Poisoner)) then
			parentFrame = "LibDBIcon10_Poisoner"
		else
			parentFrame = "Poisoner_FreeButton"
		end
		PoisonerMenu:SetPoint(p, parentFrame, rp);
		POISONER_CONFIG.Menu.Parent = parent]]
		PoisonerMenu:Show();
	end
end

--
-- Dragging
--

-- Start dragging the poison button
function Poisoner_OnDragStart(self)
	if (POISONER_CONFIG.Buttons.FreeButton.Lock == 0 and not Poisoner_BeingDragged) then
		self:StartMoving();
		Poisoner_BeingDragged = true;
	else
		DEFAULT_CHAT_FRAME:AddMessage(POISONER_DRAGERROR, 1.0, 1.0, 0.5);
	end
end

-- Stop dragging the poison button
function Poisoner_OnDragStop(self)
	if (Poisoner_BeingDragged) then
		self:StopMovingOrSizing()
		Poisoner_BeingDragged = false
		POISONER_CONFIG.Buttons.FreeButton.Position.Anchor, _, POISONER_CONFIG.Buttons.FreeButton.Position.RelativePoint, POISONER_CONFIG.Buttons.FreeButton.Position.XPos, POISONER_CONFIG.Buttons.FreeButton.Position.YPos = self:GetPoint()
	end
end

function Poisoner_DragLock()
	POISONER_CONFIG.Buttons.FreeButton.Lock = 1;
end

function Poisoner_DragUnlock()
	POISONER_CONFIG.Buttons.FreeButton.Lock = 0;
	Poisoner_BeingDragged = false;
end

function Poisoner_DragReset()
	Poisoner_FreeButton:ClearAllPoints();
	Poisoner_FreeButton:SetPoint("BOTTOM", Minimap, -72, 112);
end


-- 
-- Scaling and position options
--

function Poisoner_SetScale(scale)
	POISONER_CONFIG.Menu.Scale = scale;
	PoisonerMenu:SetScale(scale);
end

function Poisoner_SetPosition(position)
	local menu = PoisonerMenu;
	if not position then
		position = POISONER_CONFIG.Menu.Position
	end
	if (position == "left" or position == "right" or position == "bottom" or position == "bottomright" or position == "bottomleft" or position == "topright" or position == "topleft" or position == "top") then
		POISONER_CONFIG.Menu.Position = position;
		PoisonerMenu:ClearAllPoints();
		local parent = POISONER_CONFIG.Menu.Parent
		local parentFrame
		local p, rp;
		if (position == "top") then
			menu:SetWidth("36");
			menu:SetHeight("240");
			p = "BOTTOM";
			rp = "TOP";
		elseif (position == "topleft") then
			menu:SetWidth("240");
			menu:SetHeight("36");
			p = "BOTTOMRIGHT";
			rp = "LEFT";
		elseif (position == "topright") then
			menu:SetWidth("240");
			menu:SetHeight("36");
			p = "BOTTOMLEFT";
			rp = "RIGHT";
		elseif (position == "left") then
			menu:SetWidth("240");
			menu:SetHeight("36");
			p = "RIGHT";
			rp = "LEFT";
		elseif (position == "right") then
			menu:SetWidth("240");
			menu:SetHeight("36");
			p = "LEFT";
			rp = "RIGHT";		
		elseif (position == "bottom") then
			menu:SetWidth("36");
			menu:SetHeight("240");
			p = "TOP";
			rp = "BOTTOM";
		elseif (position == "bottomleft") then
			menu:SetWidth("240");
			menu:SetHeight("36");
			p = "TOPRIGHT";
			rp = "LEFT";
		elseif (position == "bottomright") then
			menu:SetWidth("240");
			menu:SetHeight("36");
			p = "TOPLEFT";
			rp = "RIGHT";
		else
			menu:SetWidth("240");
			menu:SetHeight("36");
			p = "TOPRIGHT";
			rp = "LEFT";
		end
		PoisonerMenu:ClearAllPoints()
		if ((parent == "Minimap") and (LibDBIcon10_Poisoner)) then
			parentFrame = "LibDBIcon10_Poisoner"
		else
			parentFrame = "Poisoner_FreeButton"
		end
		PoisonerMenu:SetPoint(p, parentFrame, rp);
		POISONER_CONFIG.Menu.Parent = parent
		--PoisonerMenu:SetPoint(p, Poisoner_FreeButton, rp);
	else
		-- error
		DEFAULT_CHAT_FRAME:AddMessage(POISONER_POSITIONERROR, 1.0, 1.0, 0.5);
	end
	if player_entered_world then
		Poisoner_CreateButtons();
	end
end


--
-- ToolTips for type "full"/"name only"
--

function Poisoner_Tooltip(self,pbagid,pbagslot,pttip)
	GameTooltip:SetOwner(self,"BOTTOMLEFT");
	if (POISONER_CONFIG.TooltipType == "full") then
		GameTooltip:SetBagItem(pbagid,pbagslot);
	else
		GameTooltip:SetText(pttip, 1.00, 1.00, 1.00);
	end
	GameTooltip:Show();
end


--
-- ToolTips for QuickButton
--

function Poisoner_QuickButton_Tooltip(self)
	GameTooltip:SetOwner(self,"BOTTOMLEFT");
	GameTooltip:ClearLines();
	--GameTooltip:AddLine(Poisoner_QuickButton_Text, 1.00, 1.00, 1.00);
	--GameTooltip:SetText(Poisoner_QuickButton_Text, 1.00, 1.00, 1.00);
	--GameTooltip:AddLine("|T"..Texture..":0|t ")
	GameTooltip:AddDoubleLine(Poisoner_QuickButton_Text_Slots, Poisoner_QuickButton_Text_Textures, 1,1,1, 1,1,1);
	GameTooltip:Show();
end


--
-- QuickButton DragHandler
--
function Poisoner_QuickButton_CreateOverlay()
	--	Overlay
	--[[local f = CreateFrame("Frame", "Poisoner_QuickButton_Overlay", UIParent)
	f:SetFrameStrata("DIALOG")
	f:SetWidth(30) 
	f:SetHeight(30)]]
	
	local t = Poisoner_QuickButton_Overlay:CreateTexture("Poisoner_QuickButton_OverlayBackground","BACKGROUND")
	t:SetTexture(1,1,1,0)
	t:SetAllPoints(Poisoner_QuickButton_Overlay)
	Poisoner_QuickButton_Overlay.texture = t
	
	Poisoner_QuickButton_Overlay:Show()
end

function Poisoner_QuickButton_UpdateLock()
	
	if (POISONER_CONFIG.Buttons.QuickButton.Lock == 1) then
		Poisoner_QuickButton_Overlay:RegisterForDrag()
		Poisoner_QuickButton_OverlayBackground:SetTexture(0,1,0,0)
		Poisoner_QuickButton_Overlay:SetMovable(false)
		Poisoner_QuickButton_Overlay:EnableMouse(false)
		Poisoner_QuickButton_Overlay:SetScript("OnDragStart", nil)
		Poisoner_QuickButton_Overlay:SetScript("OnDragStop", nil)		
	else
		Poisoner_QuickButton_Overlay:Show()
		Poisoner_QuickButton_Overlay:RegisterForDrag("LeftButton")
		Poisoner_QuickButton_OverlayBackground:SetTexture(0,1,0,0.5)
		Poisoner_QuickButton_Overlay:SetMovable(true)
		Poisoner_QuickButton_Overlay:EnableMouse(true)
		Poisoner_QuickButton_Overlay:SetScript("OnDragStart", Poisoner_QuickButton_OnDragStart)
		Poisoner_QuickButton_Overlay:SetScript("OnDragStop", Poisoner_QuickButton_OnDragStop)
	end
end


-- Start dragging QuickButton
function Poisoner_QuickButton_OnDragStart(self)
	
	self:StartMoving();
	Poisoner_QuickButton_BeingDragged = true;
	
end

-- Stop dragging QuickButton
function Poisoner_QuickButton_OnDragStop(self)
	if (Poisoner_QuickButton_BeingDragged) then
		self:StopMovingOrSizing()
		POISONER_CONFIG.Buttons.QuickButton.Position.Anchor, _, POISONER_CONFIG.Buttons.QuickButton.Position.RelativePoint, POISONER_CONFIG.Buttons.QuickButton.Position.XPos, POISONER_CONFIG.Buttons.QuickButton.Position.YPos = Poisoner_QuickButton_Overlay:GetPoint();
		Poisoner_QuickButton_BeingDragged = false;
	end
end

function Poisoner_QuickButton_Reset()
	POISONER_CONFIG.Buttons.QuickButton.Position = { 
		XPos = 0,
		YPos = 0,
		Anchor = "CENTER",
		RelativeTo = "UIParent",
		RelativePoint = "CENTER",
		Parent = nil,
		}
	
	Poisoner_QuickButton_Overlay:ClearAllPoints()
	Poisoner_QuickButton_Overlay:SetPoint(POISONER_CONFIG.Buttons.QuickButton.Position.Anchor, "UIParent", POISONER_CONFIG.Buttons.QuickButton.Position.RelativeTo, POISONER_CONFIG.Buttons.QuickButton.Position.XPos, POISONER_CONFIG.Buttons.QuickButton.Position.YPos)
	Poisoner_QuickButton_Overlay:SetScale(POISONER_CONFIG.Buttons.QuickButton.Scale)
	Poisoner_QuickButton_Overlay:SetAlpha(POISONER_CONFIG.Buttons.QuickButton.Alpha)
	Poisoner_QuickButton_Overlay:Show()
	POISONER_CONFIG.Buttons.QuickButton.Lock = 0
	Poisoner_QuickButton_UpdateLock()
end


--
-- Debugging : set to true if ya want it on
--

function Poisoner_Debug(message)
	if (Poisoner_PrintDebug) then
		if (message == nil) then
			message = "<nil>";
		end
		DEFAULT_CHAT_FRAME:AddMessage(message);
	end
end


--
-- Saying THANK YOU
--

function Poisoner_Thanks()
	local people = {
		"Nyss / Horstl",
		"Ysinthe / Ryjnjohl",
		"TrAsHeR",
		"Itonohito",
		"- Me and Myself -",
	}
	
	print(POISONER_THANKYOUTEXT)
	for k,v in pairs(people) do
		print(" "..v)
	end
	
end


--
--	DataBroker and LDBIcon
--
local LDB		= LibStub("LibDataBroker-1.1")
local LDBIcon	= LibStub("LibDBIcon-1.0")
local data_obj

function Poisoner_LDB_OnEnable()
	data_obj = LDB:NewDataObject("Poisoner", {
		type	= "data source",
		label	= "Poisoner",
		text	= " ",
		icon	= "Interface\\Icons\\Spell_Nature_CorrosiveBreath",
		OnEnter	= function()				  
			  end,
		-- OnLeave is an empty function because some LDB displays refuse to display a plugin that has an OnEnter but no OnLeave.
		OnLeave	= function()
			  end,
		OnClick = function(display, button)
				  if button == "RightButton" then
					PoisonerOptions_ToggleSettings()
				  elseif button == "LeftButton" then
					PoisonerMenu_Toggle()
				  elseif button == "MiddleButton" then
					print("Poisoner_LDB: MiddleButton")
				  end
			  end,
	})
	--UpdateDataFeed()

	if LDBIcon then
		LDBIcon:Register("Poisoner", data_obj, POISONER_CONFIG.Buttons.LDBIcon)
	end
end

function Poisoner_LDB_Enable()
	POISONER_CONFIG.Buttons.LDBIcon.hide = "false"
	LDBIcon:Show("Poisoner")
	Poisoner_ShowLDBIcon = 1
	Poisoner_SetPosition()
	PoisonerStateHeader:SetScript("OnUpdate", nil);
end
function Poisoner_LDB_Disable()
	POISONER_CONFIG.Buttons.LDBIcon.hide = "true"
	LDBIcon:Hide("Poisoner")
	Poisoner_ShowLDBIcon = 0
	Poisoner_SetPosition()
	PoisonerStateHeader:SetScript("OnUpdate", nil);
end



function Poisoner_LoadMySettings()

POISONER_CONFIG = {
	["Enabled"] = 1,
	["Buttons"] = {
		["FreeButton"] = {
			["Active"] = 1,
			["Scale"] = 1,
			["Lock"] = 1,
			["Alpha"] = 1,
			["Position"] = {
				["RelativeTo"] = "UIParent",
				["XPos"] = 10.00000014057727,
				["RelativePoint"] = "BOTTOMRIGHT",
				["Anchor"] = "BOTTOMRIGHT",
				["YPos"] = 107.9999974696091,
			},
		},
		["QuickButton"] = {
			["Scale"] = 1.100000023841858,
			["Lock"] = 1,
			["Alpha"] = 1,
			["Position"] = {
				["RelativeTo"] = "UIParent",
				["XPos"] = 12.36998335073094,
				["RelativePoint"] = "BOTTOMRIGHT",
				["Anchor"] = "BOTTOMRIGHT",
				["YPos"] = 69.9192657705381,
			},
		},
		["LDBIcon"] = {
			["hide"] = "true",
		},
	},
	["Preset"] = {
		["Normal"] = {
			["Mainhand"] = 5,
			["Throwweapon"] = 5,
			["Offhand"] = 4,
		},
		["CTRL"] = {
			["Mainhand"] = 3,
			["Throwweapon"] = 3,
			["Offhand"] = 6,
		},
		["Overwrite"] = 1,
		["ALT"] = {
			["Mainhand"] = 6,
			["Throwweapon"] = 6,
			["Offhand"] = 3,
		},
		["SHIFT"] = {
			["Mainhand"] = 4,
			["Throwweapon"] = 4,
			["Offhand"] = 5,
		},
	},
	["TooltipType"] = "full",
	["Menu"] = {
		["Scale"] = 1,
		["Spacing"] = 0,
		["Parent"] = "Poisoner_FreeButton",
		["AutoHide"] = {
			["Active"] = 0,
			["Time"] = 10,
			["inCombat"] = 0,
		},
		["ShowOnMouseover"] = 1,
		["Position"] = "left",
	},
	["Version"] = "4.2",
	["PrintClickedPoison"] = 0,
	["Timer"] = {
		["Active"] = 1,
		["Scale"] = 0.5,
		["WarningThreshold"] = 5,
		["Alpha"] = 1,
		["Output"] = {
			["Chat"] = 1,
			["ErrorFrame"] = 1,
			["Audio"] = 1,
			["Aura"] = 1,
		},
		["IgnoreWhileFishing"] = 0,
		["Position"] = {
			["Anchor"] = "TOP",
			["YPos"] = -301.7778253553741,
			["XPos"] = -1.777706567580309,
			["RelativePoint"] = "TOP",
		},
		["Lock"] = 1,
		["Weapon"] = {
			["MainHand"] = 1,
			["OffHand"] = 1,
			["ThrowWeapon"] = 1,
		},
	},
	["StartedOnce"] = 1,
	["Poisons"] = {
		["WPName"] = "Wundgift",
		["MPName"] = "Gedankenbenebelndes Gift",
		["DPName"] = "Tödliches Gift",
		["CPName"] = "Verkrüppelndes Gift",
		["IPName"] = "Sofort wirkendes Gift",
	},
	["Buy"] = {
		["Active"] = 1,
		["WP"] = 0,
		["DP"] = 20,
		["MP"] = 0,
		["Check"] = 1,
		["Prompt"] = 0,
		["CP"] = 0,
		["IP"] = 40,
	},
}

end