﻿--[[ 

	Poisoner
	¯¯¯¯¯¯¯¯¯¯
	> Dropdown menu for poison presets

]]


function Poisoner_DropDownMenu_CreateFrames()
	--[[
	local CPName = GetItemInfo(3775);	--Verkrüppelndes Gift
	local MPName = GetItemInfo(5237);	--Gedankenbenebelndes Gift
	local DPName = GetItemInfo(2892);	--Tödliches Gift
	local IPName = GetItemInfo(6947);	--Sofort wirkendes Gift
	local WPName = GetItemInfo(10918);	--Wundgift
	]]

	local CPName = POISONER_CONFIG.Poisons.CPName		--Verkrüppelndes Gift
	local MPName = POISONER_CONFIG.Poisons.MPName		--Gedankenbenebelndes Gift
	local DPName = POISONER_CONFIG.Poisons.DPName		--Tödliches Gift
	local IPName = POISONER_CONFIG.Poisons.IPName		--Sofort wirkendes Gift
	local WPName = POISONER_CONFIG.Poisons.WPName		--Wundgift

	local poisons = {
		NONE,	--[1]
		CPName,	--[2]
		MPName,	--[3]
		DPName,	--[4]
		IPName,	--[5]
		WPName,	--[6]
	}
	
	PoisonerDropDown_CreateFrame_Normal(poisons)
	PoisonerDropDown_CreateFrame_SHIFT(poisons)
	PoisonerDropDown_CreateFrame_CTRL(poisons)
	PoisonerDropDown_CreateFrame_ALT(poisons)

end

function PoisonerDropDown_CreateFrame_Normal(poisons)
	
	--
	-- DropDownMenu - Mainhand
	--
	if not Poisoner_DropDownMenu_Mainhand then
		CreateFrame("Button", "Poisoner_DropDownMenu_Mainhand", PoisonerOptions_DropdownFrame1, "UIDropDownMenuTemplate")
	end
	 
	Poisoner_DropDownMenu_Mainhand:ClearAllPoints()
	Poisoner_DropDownMenu_Mainhand:SetPoint("TOPLEFT", PoisonerOptions_DropdownFrame1, "TOPLEFT", -20, -15)
	Poisoner_DropDownMenu_Mainhand:Show()

	local function OnClick(self)
		UIDropDownMenu_SetSelectedID(Poisoner_DropDownMenu_Mainhand, self:GetID())
		local id = self:GetID()
		PoisonerDropDown_SelectPresetPoison("Mainhand", id, "Normal")
	end
	 
	local function initialize(self, level)
		local info = UIDropDownMenu_CreateInfo()
		for k,v in pairs(poisons) do
			info = UIDropDownMenu_CreateInfo()
			info.text = v
			info.value = v
			info.func = OnClick
			UIDropDownMenu_AddButton(info, level)
		end
	end 
	 
	UIDropDownMenu_Initialize(Poisoner_DropDownMenu_Mainhand, initialize)
	UIDropDownMenu_SetWidth(Poisoner_DropDownMenu_Mainhand, 100);
	UIDropDownMenu_SetButtonWidth(Poisoner_DropDownMenu_Mainhand, 120)
	UIDropDownMenu_SetSelectedID(Poisoner_DropDownMenu_Mainhand, 1)
	UIDropDownMenu_JustifyText(Poisoner_DropDownMenu_Mainhand, "LEFT")



	--
	-- DropDownMenu - Offhand
	--
	if not Poisoner_DropDownMenu_Offhand then
		CreateFrame("Button", "Poisoner_DropDownMenu_Offhand", PoisonerOptions_DropdownFrame2, "UIDropDownMenuTemplate")
	end
	 
	Poisoner_DropDownMenu_Offhand:ClearAllPoints()
	Poisoner_DropDownMenu_Offhand:SetPoint("TOPLEFT", PoisonerOptions_DropdownFrame2, "TOPLEFT", -20, -15)
	Poisoner_DropDownMenu_Offhand:Show()

	local function OnClick(self)
		UIDropDownMenu_SetSelectedID(Poisoner_DropDownMenu_Offhand, self:GetID())
		local id = self:GetID()
		PoisonerDropDown_SelectPresetPoison("Offhand", id, "Normal")
	end
	 
	local function initialize(self, level)
		local info = UIDropDownMenu_CreateInfo()
		for k,v in pairs(poisons) do
			info = UIDropDownMenu_CreateInfo()
			info.text = v
			info.value = v
			info.func = OnClick
			UIDropDownMenu_AddButton(info, level)
		end
	end 
	 
	UIDropDownMenu_Initialize(Poisoner_DropDownMenu_Offhand, initialize)
	UIDropDownMenu_SetWidth(Poisoner_DropDownMenu_Offhand, 100);
	UIDropDownMenu_SetButtonWidth(Poisoner_DropDownMenu_Offhand, 120)
	UIDropDownMenu_SetSelectedID(Poisoner_DropDownMenu_Offhand, 1)
	UIDropDownMenu_JustifyText(Poisoner_DropDownMenu_Offhand, "LEFT")



	--
	-- DropDownMenu - Throw weapon
	--
	if not Poisoner_DropDownMenu_Throwweapon then
		CreateFrame("Button", "Poisoner_DropDownMenu_Throwweapon", PoisonerOptions_DropdownFrame3, "UIDropDownMenuTemplate")
	end
	 
	Poisoner_DropDownMenu_Throwweapon:ClearAllPoints()
	Poisoner_DropDownMenu_Throwweapon:SetPoint("TOPLEFT", PoisonerOptions_DropdownFrame3, "TOPLEFT", -20, -15)
	Poisoner_DropDownMenu_Throwweapon:Show()
	 
	local function OnClick(self)
		UIDropDownMenu_SetSelectedID(Poisoner_DropDownMenu_Throwweapon, self:GetID())
		local id = self:GetID()
		PoisonerDropDown_SelectPresetPoison("Throwweapon", id, "Normal")
	end
	 
	local function initialize(self, level)
		local info = UIDropDownMenu_CreateInfo()
		for k,v in pairs(poisons) do
			info = UIDropDownMenu_CreateInfo()
			info.text = v
			info.value = v
			info.func = OnClick
			UIDropDownMenu_AddButton(info, level)
		end
	end 
	 
	UIDropDownMenu_Initialize(Poisoner_DropDownMenu_Throwweapon, initialize)
	UIDropDownMenu_SetWidth(Poisoner_DropDownMenu_Throwweapon, 100);
	UIDropDownMenu_SetButtonWidth(Poisoner_DropDownMenu_Throwweapon, 120)
	UIDropDownMenu_SetSelectedID(Poisoner_DropDownMenu_Throwweapon, 1)
	UIDropDownMenu_JustifyText(Poisoner_DropDownMenu_Throwweapon, "LEFT")
	
end

function PoisonerDropDown_CreateFrame_SHIFT(poisons)
	
	--
	-- DropDownMenu - Mainhand
	--
	if not Poisoner_DropDownMenu_Mainhand_SHIFT then
		CreateFrame("Button", "Poisoner_DropDownMenu_Mainhand_SHIFT", PoisonerOptions_DropdownFrame_SHIFT1, "UIDropDownMenuTemplate")
	end
	 
	Poisoner_DropDownMenu_Mainhand_SHIFT:ClearAllPoints()
	Poisoner_DropDownMenu_Mainhand_SHIFT:SetPoint("TOPLEFT", PoisonerOptions_DropdownFrame_SHIFT1, "TOPLEFT", -20, -15)
	Poisoner_DropDownMenu_Mainhand_SHIFT:Show()

	local function OnClick(self)
		UIDropDownMenu_SetSelectedID(Poisoner_DropDownMenu_Mainhand_SHIFT, self:GetID())
		local id = self:GetID()
		PoisonerDropDown_SelectPresetPoison("Mainhand", id, "SHIFT")
	end
	 
	local function initialize(self, level)
		local info = UIDropDownMenu_CreateInfo()
		for k,v in pairs(poisons) do
			info = UIDropDownMenu_CreateInfo()
			info.text = v
			info.value = v
			info.func = OnClick
			UIDropDownMenu_AddButton(info, level)
		end
	end 
	 
	UIDropDownMenu_Initialize(Poisoner_DropDownMenu_Mainhand_SHIFT, initialize)
	UIDropDownMenu_SetWidth(Poisoner_DropDownMenu_Mainhand_SHIFT, 100);
	UIDropDownMenu_SetButtonWidth(Poisoner_DropDownMenu_Mainhand_SHIFT, 120)
	UIDropDownMenu_SetSelectedID(Poisoner_DropDownMenu_Mainhand_SHIFT, 1)
	UIDropDownMenu_JustifyText(Poisoner_DropDownMenu_Mainhand_SHIFT, "LEFT")



	--
	-- DropDownMenu - Offhand
	--
	if not Poisoner_DropDownMenu_Offhand_SHIFT then
		CreateFrame("Button", "Poisoner_DropDownMenu_Offhand_SHIFT", PoisonerOptions_DropdownFrame_SHIFT2, "UIDropDownMenuTemplate")
	end
	 
	Poisoner_DropDownMenu_Offhand_SHIFT:ClearAllPoints()
	Poisoner_DropDownMenu_Offhand_SHIFT:SetPoint("TOPLEFT", PoisonerOptions_DropdownFrame_SHIFT2, "TOPLEFT", -20, -15)
	Poisoner_DropDownMenu_Offhand_SHIFT:Show()

	local function OnClick(self)
		UIDropDownMenu_SetSelectedID(Poisoner_DropDownMenu_Offhand_SHIFT, self:GetID())
		local id = self:GetID()
		PoisonerDropDown_SelectPresetPoison("Offhand", id, "SHIFT")
	end
	 
	local function initialize(self, level)
		local info = UIDropDownMenu_CreateInfo()
		for k,v in pairs(poisons) do
			info = UIDropDownMenu_CreateInfo()
			info.text = v
			info.value = v
			info.func = OnClick
			UIDropDownMenu_AddButton(info, level)
		end
	end 
	 
	UIDropDownMenu_Initialize(Poisoner_DropDownMenu_Offhand_SHIFT, initialize)
	UIDropDownMenu_SetWidth(Poisoner_DropDownMenu_Offhand_SHIFT, 100);
	UIDropDownMenu_SetButtonWidth(Poisoner_DropDownMenu_Offhand_SHIFT, 120)
	UIDropDownMenu_SetSelectedID(Poisoner_DropDownMenu_Offhand_SHIFT, 1)
	UIDropDownMenu_JustifyText(Poisoner_DropDownMenu_Offhand_SHIFT, "LEFT")



	--
	-- DropDownMenu - Throw weapon
	--
	if not Poisoner_DropDownMenu_Throwweapon_SHIFT then
		CreateFrame("Button", "Poisoner_DropDownMenu_Throwweapon_SHIFT", PoisonerOptions_DropdownFrame_SHIFT3, "UIDropDownMenuTemplate")
	end
	 
	Poisoner_DropDownMenu_Throwweapon_SHIFT:ClearAllPoints()
	Poisoner_DropDownMenu_Throwweapon_SHIFT:SetPoint("TOPLEFT", PoisonerOptions_DropdownFrame_SHIFT3, "TOPLEFT", -20, -15)
	Poisoner_DropDownMenu_Throwweapon_SHIFT:Show()
	 
	local function OnClick(self)
		UIDropDownMenu_SetSelectedID(Poisoner_DropDownMenu_Throwweapon_SHIFT, self:GetID())
		local id = self:GetID()
		PoisonerDropDown_SelectPresetPoison("Throwweapon", id, "SHIFT")
	end
	 
	local function initialize(self, level)
		local info = UIDropDownMenu_CreateInfo()
		for k,v in pairs(poisons) do
			info = UIDropDownMenu_CreateInfo()
			info.text = v
			info.value = v
			info.func = OnClick
			UIDropDownMenu_AddButton(info, level)
		end
	end 
	 
	UIDropDownMenu_Initialize(Poisoner_DropDownMenu_Throwweapon_SHIFT, initialize)
	UIDropDownMenu_SetWidth(Poisoner_DropDownMenu_Throwweapon_SHIFT, 100);
	UIDropDownMenu_SetButtonWidth(Poisoner_DropDownMenu_Throwweapon_SHIFT, 120)
	UIDropDownMenu_SetSelectedID(Poisoner_DropDownMenu_Throwweapon_SHIFT, 1)
	UIDropDownMenu_JustifyText(Poisoner_DropDownMenu_Throwweapon_SHIFT, "LEFT")
	
end

function PoisonerDropDown_CreateFrame_CTRL(poisons)
		
	--
	-- DropDownMenu - Mainhand
	--
	if not Poisoner_DropDownMenu_Mainhand_CTRL then
		CreateFrame("Button", "Poisoner_DropDownMenu_Mainhand_CTRL", PoisonerOptions_DropdownFrame_CTRL1, "UIDropDownMenuTemplate")
	end
	 
	Poisoner_DropDownMenu_Mainhand_CTRL:ClearAllPoints()
	Poisoner_DropDownMenu_Mainhand_CTRL:SetPoint("TOPLEFT", PoisonerOptions_DropdownFrame_CTRL1, "TOPLEFT", -20, -15)
	Poisoner_DropDownMenu_Mainhand_CTRL:Show()

	local function OnClick(self)
		UIDropDownMenu_SetSelectedID(Poisoner_DropDownMenu_Mainhand_CTRL, self:GetID())
		local id = self:GetID()
		PoisonerDropDown_SelectPresetPoison("Mainhand", id, "CTRL")
	end
	 
	local function initialize(self, level)
		local info = UIDropDownMenu_CreateInfo()
		for k,v in pairs(poisons) do
			info = UIDropDownMenu_CreateInfo()
			info.text = v
			info.value = v
			info.func = OnClick
			UIDropDownMenu_AddButton(info, level)
		end
	end 
	 
	UIDropDownMenu_Initialize(Poisoner_DropDownMenu_Mainhand_CTRL, initialize)
	UIDropDownMenu_SetWidth(Poisoner_DropDownMenu_Mainhand_CTRL, 100);
	UIDropDownMenu_SetButtonWidth(Poisoner_DropDownMenu_Mainhand_CTRL, 120)
	UIDropDownMenu_SetSelectedID(Poisoner_DropDownMenu_Mainhand_CTRL, 1)
	UIDropDownMenu_JustifyText(Poisoner_DropDownMenu_Mainhand_CTRL, "LEFT")



	--
	-- DropDownMenu - Offhand
	--
	if not Poisoner_DropDownMenu_Offhand_CTRL then
		CreateFrame("Button", "Poisoner_DropDownMenu_Offhand_CTRL", PoisonerOptions_DropdownFrame_CTRL2, "UIDropDownMenuTemplate")
	end
	 
	Poisoner_DropDownMenu_Offhand_CTRL:ClearAllPoints()
	Poisoner_DropDownMenu_Offhand_CTRL:SetPoint("TOPLEFT", PoisonerOptions_DropdownFrame_CTRL2, "TOPLEFT", -20, -15)
	Poisoner_DropDownMenu_Offhand_CTRL:Show()

	local function OnClick(self)
		UIDropDownMenu_SetSelectedID(Poisoner_DropDownMenu_Offhand_CTRL, self:GetID())
		local id = self:GetID()
		PoisonerDropDown_SelectPresetPoison("Offhand", id, "CTRL")
	end
	 
	local function initialize(self, level)
		local info = UIDropDownMenu_CreateInfo()
		for k,v in pairs(poisons) do
			info = UIDropDownMenu_CreateInfo()
			info.text = v
			info.value = v
			info.func = OnClick
			UIDropDownMenu_AddButton(info, level)
		end
	end 
	 
	UIDropDownMenu_Initialize(Poisoner_DropDownMenu_Offhand_CTRL, initialize)
	UIDropDownMenu_SetWidth(Poisoner_DropDownMenu_Offhand_CTRL, 100);
	UIDropDownMenu_SetButtonWidth(Poisoner_DropDownMenu_Offhand_CTRL, 120)
	UIDropDownMenu_SetSelectedID(Poisoner_DropDownMenu_Offhand_CTRL, 1)
	UIDropDownMenu_JustifyText(Poisoner_DropDownMenu_Offhand_CTRL, "LEFT")



	--
	-- DropDownMenu - Throw weapon
	--
	if not Poisoner_DropDownMenu_Throwweapon_CTRL then
		CreateFrame("Button", "Poisoner_DropDownMenu_Throwweapon_CTRL", PoisonerOptions_DropdownFrame_CTRL3, "UIDropDownMenuTemplate")
	end
	 
	Poisoner_DropDownMenu_Throwweapon_CTRL:ClearAllPoints()
	Poisoner_DropDownMenu_Throwweapon_CTRL:SetPoint("TOPLEFT", PoisonerOptions_DropdownFrame_CTRL3, "TOPLEFT", -20, -15)
	Poisoner_DropDownMenu_Throwweapon_CTRL:Show()
	 
	local function OnClick(self)
		UIDropDownMenu_SetSelectedID(Poisoner_DropDownMenu_Throwweapon_CTRL, self:GetID())
		local id = self:GetID()
		PoisonerDropDown_SelectPresetPoison("Throwweapon", id, "CTRL")
	end
	 
	local function initialize(self, level)
		local info = UIDropDownMenu_CreateInfo()
		for k,v in pairs(poisons) do
			info = UIDropDownMenu_CreateInfo()
			info.text = v
			info.value = v
			info.func = OnClick
			UIDropDownMenu_AddButton(info, level)
		end
	end 
	 
	UIDropDownMenu_Initialize(Poisoner_DropDownMenu_Throwweapon_CTRL, initialize)
	UIDropDownMenu_SetWidth(Poisoner_DropDownMenu_Throwweapon_CTRL, 100);
	UIDropDownMenu_SetButtonWidth(Poisoner_DropDownMenu_Throwweapon_CTRL, 120)
	UIDropDownMenu_SetSelectedID(Poisoner_DropDownMenu_Throwweapon_CTRL, 1)
	UIDropDownMenu_JustifyText(Poisoner_DropDownMenu_Throwweapon_CTRL, "LEFT")
	
end

function PoisonerDropDown_CreateFrame_ALT(poisons)
		
	--
	-- DropDownMenu - Mainhand
	--
	if not Poisoner_DropDownMenu_Mainhand_ALT then
		CreateFrame("Button", "Poisoner_DropDownMenu_Mainhand_ALT", PoisonerOptions_DropdownFrame_ALT1, "UIDropDownMenuTemplate")
	end
	 
	Poisoner_DropDownMenu_Mainhand_ALT:ClearAllPoints()
	Poisoner_DropDownMenu_Mainhand_ALT:SetPoint("TOPLEFT", PoisonerOptions_DropdownFrame_ALT1, "TOPLEFT", -20, -15)
	Poisoner_DropDownMenu_Mainhand_ALT:Show()

	local function OnClick(self)
		UIDropDownMenu_SetSelectedID(Poisoner_DropDownMenu_Mainhand_ALT, self:GetID())
		local id = self:GetID()
		PoisonerDropDown_SelectPresetPoison("Mainhand", id, "ALT")
	end
	
	local function initialize(self, level)
		local info = UIDropDownMenu_CreateInfo()
		for k,v in pairs(poisons) do
			info = UIDropDownMenu_CreateInfo()
			info.text = v
			info.value = v
			info.func = OnClick
			UIDropDownMenu_AddButton(info, level)
		end
	end 
	 
	UIDropDownMenu_Initialize(Poisoner_DropDownMenu_Mainhand_ALT, initialize)
	UIDropDownMenu_SetWidth(Poisoner_DropDownMenu_Mainhand_ALT, 100);
	UIDropDownMenu_SetButtonWidth(Poisoner_DropDownMenu_Mainhand_ALT, 120)
	UIDropDownMenu_SetSelectedID(Poisoner_DropDownMenu_Mainhand_ALT, 1)
	UIDropDownMenu_JustifyText(Poisoner_DropDownMenu_Mainhand_ALT, "LEFT")



	--
	-- DropDownMenu - Offhand
	--
	if not Poisoner_DropDownMenu_Offhand_ALT then
		CreateFrame("Button", "Poisoner_DropDownMenu_Offhand_ALT", PoisonerOptions_DropdownFrame_ALT2, "UIDropDownMenuTemplate")
	end
	 
	Poisoner_DropDownMenu_Offhand_ALT:ClearAllPoints()
	Poisoner_DropDownMenu_Offhand_ALT:SetPoint("TOPLEFT", PoisonerOptions_DropdownFrame_ALT2, "TOPLEFT", -20, -15)
	Poisoner_DropDownMenu_Offhand_ALT:Show()

	local function OnClick(self)
		UIDropDownMenu_SetSelectedID(Poisoner_DropDownMenu_Offhand_ALT, self:GetID())
		local id = self:GetID()
		PoisonerDropDown_SelectPresetPoison("Offhand", id, "ALT")
	end
	 
	local function initialize(self, level)
		local info = UIDropDownMenu_CreateInfo()
		for k,v in pairs(poisons) do
			info = UIDropDownMenu_CreateInfo()
			info.text = v
			info.value = v
			info.func = OnClick
			UIDropDownMenu_AddButton(info, level)
		end
	end 
	 
	UIDropDownMenu_Initialize(Poisoner_DropDownMenu_Offhand_ALT, initialize)
	UIDropDownMenu_SetWidth(Poisoner_DropDownMenu_Offhand_ALT, 100);
	UIDropDownMenu_SetButtonWidth(Poisoner_DropDownMenu_Offhand_ALT, 120)
	UIDropDownMenu_SetSelectedID(Poisoner_DropDownMenu_Offhand_ALT, 1)
	UIDropDownMenu_JustifyText(Poisoner_DropDownMenu_Offhand_ALT, "LEFT")



	--
	-- DropDownMenu - Throw weapon
	--
	if not Poisoner_DropDownMenu_Throwweapon_ALT then
		CreateFrame("Button", "Poisoner_DropDownMenu_Throwweapon_ALT", PoisonerOptions_DropdownFrame_ALT3, "UIDropDownMenuTemplate")
	end
	 
	Poisoner_DropDownMenu_Throwweapon_ALT:ClearAllPoints()
	Poisoner_DropDownMenu_Throwweapon_ALT:SetPoint("TOPLEFT", PoisonerOptions_DropdownFrame_ALT3, "TOPLEFT", -20, -15)
	Poisoner_DropDownMenu_Throwweapon_ALT:Show()
	 
	local function OnClick(self)
		UIDropDownMenu_SetSelectedID(Poisoner_DropDownMenu_Throwweapon_ALT, self:GetID())
		local id = self:GetID()
		PoisonerDropDown_SelectPresetPoison("Throwweapon", id, "ALT")
	end
	 
	local function initialize(self, level)
		local info = UIDropDownMenu_CreateInfo()
		for k,v in pairs(poisons) do
			info = UIDropDownMenu_CreateInfo()
			info.text = v
			info.value = v
			info.func = OnClick
			UIDropDownMenu_AddButton(info, level)
		end
	end 
	 
	UIDropDownMenu_Initialize(Poisoner_DropDownMenu_Throwweapon_ALT, initialize)
	UIDropDownMenu_SetWidth(Poisoner_DropDownMenu_Throwweapon_ALT, 100);
	UIDropDownMenu_SetButtonWidth(Poisoner_DropDownMenu_Throwweapon_ALT, 120)
	UIDropDownMenu_SetSelectedID(Poisoner_DropDownMenu_Throwweapon_ALT, 1)
	UIDropDownMenu_JustifyText(Poisoner_DropDownMenu_Throwweapon_ALT, "LEFT")
	
end


function PoisonerDropDown_SelectPresetPoison(weapon, id, modifier)
	
	local CPName = POISONER_CONFIG.Poisons.CPName		--Verkrüppelndes Gift
	local MPName = POISONER_CONFIG.Poisons.MPName		--Gedankenbenebelndes Gift
	local DPName = POISONER_CONFIG.Poisons.DPName		--Tödliches Gift
	local IPName = POISONER_CONFIG.Poisons.IPName		--Sofort wirkendes Gift
	local WPName = POISONER_CONFIG.Poisons.WPName		--Wundgift
	
	local poison
	
	if id == 2 then
		poison = CPName
	elseif id == 3 then
		poison = MPName
	elseif id == 4 then
		poison = DPName	
	elseif id == 5 then
		poison = IPName
	elseif id == 6 then
		poison = WPName
	else
		poison = ""
	end
	
	
	if weapon == "Mainhand" then
		if modifier == "Normal" then
			Poisoner_Poison16.Name = poison
			POISONER_CONFIG.Preset.Normal.Mainhand = id
		elseif modifier == "SHIFT" then
			Poisoner_Poison16_SHIFT.Name = poison
			POISONER_CONFIG.Preset.SHIFT.Mainhand = id
		elseif modifier == "CTRL" then
			Poisoner_Poison16_CTRL.Name = poison
			POISONER_CONFIG.Preset.CTRL.Mainhand = id
		elseif modifier == "ALT" then
			Poisoner_Poison16_ALT.Name = poison
			POISONER_CONFIG.Preset.ALT.Mainhand = id
		end
	elseif weapon == "Offhand" then
		if modifier == "Normal" then
			Poisoner_Poison17.Name = poison
			POISONER_CONFIG.Preset.Normal.Offhand = id
		elseif modifier == "SHIFT" then
			Poisoner_Poison17_SHIFT.Name = poison
			POISONER_CONFIG.Preset.SHIFT.Offhand = id
		elseif modifier == "CTRL" then
			Poisoner_Poison17_CTRL.Name = poison
			POISONER_CONFIG.Preset.CTRL.Offhand = id
		elseif modifier == "ALT" then
			Poisoner_Poison17_ALT.Name = poison
			POISONER_CONFIG.Preset.ALT.Offhand = id
		end
	elseif weapon == "Throwweapon" then
		if modifier == "Normal" then
			Poisoner_Poison18.Name = poison
			POISONER_CONFIG.Preset.Normal.Throwweapon = id
		elseif modifier == "SHIFT" then
			Poisoner_Poison18_SHIFT.Name = poison
			POISONER_CONFIG.Preset.SHIFT.Throwweapon = id
		elseif modifier == "CTRL" then
			Poisoner_Poison18_CTRL.Name = poison
			POISONER_CONFIG.Preset.CTRL.Throwweapon = id
		elseif modifier == "ALT" then
			Poisoner_Poison18_ALT.Name = poison
			POISONER_CONFIG.Preset.ALT.Throwweapon = id
		end
	end
	
	Poisoner_PoisonSlots = {
		Poisoner_Poison16,
		Poisoner_Poison16_SHIFT,
		Poisoner_Poison16_CTRL,
		Poisoner_Poison16_ALT,
		Poisoner_Poison17,
		Poisoner_Poison17_SHIFT,
		Poisoner_Poison17_CTRL,
		Poisoner_Poison17_ALT,
		Poisoner_Poison18,
		Poisoner_Poison18_SHIFT,
		Poisoner_Poison18_CTRL,
		Poisoner_Poison18_ALT,
	}
	
	if InCombatLockdown() then
		PoisonerStateHeader.needUpdate = true
	else
		Poisoner_GetToolTipTexture()
		Poisoner_CheckQuickButton()
	end
	
end


function PoisonerDropDown_UpdateDropDownText(frame, id)
	
	local CPName = POISONER_CONFIG.Poisons.CPName		--Verkrüppelndes Gift
	local MPName = POISONER_CONFIG.Poisons.MPName		--Gedankenbenebelndes Gift
	local DPName = POISONER_CONFIG.Poisons.DPName		--Tödliches Gift
	local IPName = POISONER_CONFIG.Poisons.IPName		--Sofort wirkendes Gift
	local WPName = POISONER_CONFIG.Poisons.WPName		--Wundgift
	
	local poison
	
	if id == 2 then
		poison = CPName
	elseif id == 3 then
		poison = MPName
	elseif id == 4 then
		poison = DPName	
	elseif id == 5 then
		poison = IPName
	elseif id == 6 then
		poison = WPName
	else
		poison = NONE
	end
	
	UIDropDownMenu_SetSelectedID(frame, id)
	UIDropDownMenu_SetText(frame, poison)
	
end






