﻿--[[ 

	Poisoner
	¯¯¯¯¯¯¯¯¯¯
	> Timer

]]
-- Colours


local COLOR_BLUE = "|cff0000ff";
local COLOR_GOLD = "|cffcfb52b";
local COLOR_GREEN = "|cff00ff00";	-- Poison
local COLOR_GREY = "|cff808080";
local COLOR_NEON_BLUE = "|cff4d4dff";
local COLOR_ORANGE = "|cffff6d00";
local COLOR_PURPLE = "|cff700090";
local COLOR_RED = "|cffff0000";		-- "not"
local COLOR_WHITE = "|cffffffff";	-- WeaponName
local COLOR_YELLOW = "|cffffff00";
local COLOR_END = "|r";

local weapon = ENCHSLOT_WEAPON

local GetPoisonsOnce = 0

local Poisoner_PoisonTimeLeft1, Poisoner_PoisonTimeLeft2, Poisoner_PoisonTimeLeft3

function PoisonerTimer_OnUpdate(self, elapsed)

	if GetPoisonsOnce == 0 then
		Poisoner_GetPoisonNames();
		GetPoisonsOnce = 1
	end

	local _,_,MainHand_ID = string.find(GetInventoryItemLink("player",GetInventorySlotInfo("MainHandSlot")) or "","(item:%d+:%d+:%d+:%d+)")
	if (MainHand_ID ~= nil) then
		_,_,_,_,_,PoisonerTimer_MainHand_itemType,PoisonerTimer_MainHand_itemSubType = GetItemInfo(MainHand_ID)
	elseif (MainHand_ID == nil) then
		PoisonerTimer_MainHand_itemType = "";
	end
	local _,_,OffHand_ID = string.find(GetInventoryItemLink("player",GetInventorySlotInfo("SecondaryHandSlot")) or "","(item:%d+:%d+:%d+:%d+)")
	if (OffHand_ID ~= nil) then
		_,_,_,_,_,PoisonerTimer_OffHand_itemType,PoisonerTimer_OffHand_itemSubType = GetItemInfo(OffHand_ID)
	elseif (OffHand_ID == nil) then
		PoisonerTimer_OffHand_itemType = "";
	end
	local _,_,ThrowWeapon_ID = string.find(GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")) or "","(item:%d+:%d+:%d+:%d+)")
	if (ThrowWeapon_ID ~= nil) then
		_,_,_,_,_,PoisonerTimer_ThrowWeapon_itemType,PoisonerTimer_ThrowWeapon_itemSubType = GetItemInfo(ThrowWeapon_ID)
	elseif (ThrowWeapon_ID == nil) then
		PoisonerTimer_ThrowWeapon_itemType = "";
	end
	
	local ignorewhilefishing
	local isfishingpole = select(7,GetItemInfo(6256))
	if (POISONER_CONFIG.Timer.IgnoreWhileFishing == 1) and (PoisonerTimer_MainHand_itemSubType == isfishingpole) then
		ignorewhilefishing = true
	else
		ignorewhilefishing = false
	end
	
	local inInstance, instanceType = IsInInstance()
	
	local hasMainHandEnchant, mainHandExpiration, mainHandCharges, hasOffHandEnchant, offHandExpiration, offHandCharges, hasThrownEnchant, thrownExpiration, thrownCharges = GetWeaponEnchantInfo();

	if (POISONER_CONFIG.Enabled == 1) and (POISONER_CONFIG.Timer.Active == 1) and (UnitLevel("player") >= 10) then
		local WarningThreshold = math.floor(Poisoner_WarningThreshold*60000)
		
		if IsMounted() then
			PoisonerTimer_Mainhand:Hide()
			PoisonerTimer_Offhand:Hide()
			PoisonerTimer_Throwweapon:Hide()
		elseif IsResting()
		or UnitInVehicle("player") 
		or UnitIsDead("player") 
		or ignorewhilefishing 
		or (inInstance == nil and POISONER_CONFIG.Timer.OnlyInstanced == 1)
		or (POISONER_CONFIG.Timer.Weapon.MainHand == 0 and POISONER_CONFIG.Timer.Weapon.OffHand == 0 and POISONER_CONFIG.Timer.Weapon.ThrowWeapon == 0) then
			PoisonerTimer_Disable()
		else
				-- Mainhand weapon
			if PoisonerTimer_MainHand_itemType == ENCHSLOT_WEAPON and POISONER_CONFIG.Timer.Weapon.MainHand == 1 then
				PoisonerTimer_UpdateIconTexture(PoisonerTimer_Mainhand, PoisonerTimer_MainhandIcon, 16)
				if hasMainHandEnchant then 
					Poisoner_PoisonTimeLeft1 = Poisoner_round((mainHandExpiration/60000), 0);	--math.floor(mainHandExpiration/60000)
					local timeformat = PoisonerOptions_LB_TimerOutput_Text_Minutes
					if mainHandExpiration <= 30000 then
						Poisoner_PoisonTimeLeft1 = Poisoner_round((mainHandExpiration/1000), 0);
						timeformat = PoisonerOptions_LB_TimerOutput_Text_Seconds
					end
					Poisoner_NoPoison_Warning1 = false
					
					if mainHandExpiration >= WarningThreshold then
						Poisoner_MinWarning1 = false
						PoisonerTimer_Mainhand:Hide()
					end 
					if (not Poisoner_MinWarning1) and (mainHandExpiration <= WarningThreshold) and ( Poisoner_PoisonTimeLeft1 ~= 0 ) and mainHandExpiration > 0 then
						if (POISONER_CONFIG.Timer.Output.Audio == 1) and (not Poisoner_MinWarning1) then
							PoisonerSound_PlaySound("expiring")
						end
						if (POISONER_CONFIG.Timer.Output.Chat == 1) and (not Poisoner_MinWarning1) then
							PoisonerTimer_Print("Poisoner_ExpirationWarning", DEFAULT_CHAT_FRAME, INVTYPE_WEAPONMAINHAND, Poisoner_PoisonTimeLeft1, timeformat, 33)
						end
						if (POISONER_CONFIG.Timer.Output.ErrorFrame == 1) and (not Poisoner_MinWarning1) then
							PoisonerTimer_Print("Poisoner_ExpirationWarning", UIErrorsFrame, INVTYPE_WEAPONMAINHAND, Poisoner_PoisonTimeLeft1, timeformat, 33)
						end
						if (POISONER_CONFIG.Timer.Output.Aura == 1) and (not Poisoner_MinWarning1) then
							PoisonerTimer_UpdateIconFrame(PoisonerTimer_Mainhand, PoisonerTimer_MainhandIcon, 16, 0.5)
						end
						Poisoner_MinWarning1 = true
					elseif (not Poisoner_MinWarning1) and (mainHandExpiration <= WarningThreshold) then
						Poisoner_MinWarning1 = true
					end
					
				else
					if (not Poisoner_NoPoison_Warning1) then
						if (POISONER_CONFIG.Timer.Output.Audio == 1) then
							PoisonerSound_PlaySound("nopoison")
						end
						if (POISONER_CONFIG.Timer.Output.Chat == 1) then
							PoisonerTimer_Print("Poisoner_NoPoison_Warning", DEFAULT_CHAT_FRAME, INVTYPE_WEAPONMAINHAND, _, _, 33)
						end
						if (POISONER_CONFIG.Timer.Output.ErrorFrame == 1) then
							PoisonerTimer_Print("Poisoner_NoPoison_Warning", UIErrorsFrame, INVTYPE_WEAPONMAINHAND, _, _, 33)
						end
						Poisoner_NoPoison_Warning1 = true
					end
					if (POISONER_CONFIG.Timer.Output.Aura == 1) then
						PoisonerTimer_UpdateIconFrame(PoisonerTimer_Mainhand, PoisonerTimer_MainhandIcon, 16, 1)
					end
				end
			else
				--print("NO mainhand weapon equipped")
				PoisonerTimer_Mainhand:Hide()
				Poisoner_MinWarning1 = false
				Poisoner_NoPoison_Warning1 = false
			end
				
				-- Offhand weapon
			if PoisonerTimer_OffHand_itemType == ENCHSLOT_WEAPON and POISONER_CONFIG.Timer.Weapon.OffHand == 1 then
				PoisonerTimer_UpdateIconTexture(PoisonerTimer_Offhand, PoisonerTimer_OffhandIcon, 17)
				if hasOffHandEnchant then 
					Poisoner_PoisonTimeLeft2 = Poisoner_round((offHandExpiration/60000), 0)	--math.floor(offHandExpiration/60000)
					local timeformat = PoisonerOptions_LB_TimerOutput_Text_Minutes
					if offHandExpiration <= 30000 then
						Poisoner_PoisonTimeLeft2 = Poisoner_round((offHandExpiration/1000), 0)
						timeformat = PoisonerOptions_LB_TimerOutput_Text_Seconds
					end
					Poisoner_NoPoison_Warning2 = false
					
					if offHandExpiration >= WarningThreshold then
						Poisoner_MinWarning2 = false
						PoisonerTimer_Offhand:Hide()
					end 
					if (not Poisoner_MinWarning2) and (offHandExpiration <= WarningThreshold) and ( Poisoner_PoisonTimeLeft2 ~= 0 ) and offHandExpiration > 0 then
						if (POISONER_CONFIG.Timer.Output.Audio == 1) and (not Poisoner_MinWarning2) then
							PoisonerSound_PlaySound("expiring")
						end
						if (POISONER_CONFIG.Timer.Output.Chat == 1) and (not Poisoner_MinWarning2) then
							PoisonerTimer_Print("Poisoner_ExpirationWarning", DEFAULT_CHAT_FRAME, INVTYPE_WEAPONOFFHAND, Poisoner_PoisonTimeLeft2, timeformat, 33)
						end
						if (POISONER_CONFIG.Timer.Output.ErrorFrame == 1) and (not Poisoner_MinWarning2) then
							PoisonerTimer_Print("Poisoner_ExpirationWarning", UIErrorsFrame, INVTYPE_WEAPONOFFHAND, Poisoner_PoisonTimeLeft2, timeformat, 34)
						end
						if (POISONER_CONFIG.Timer.Output.Aura == 1) and (not Poisoner_MinWarning2) then
							PoisonerTimer_UpdateIconFrame(PoisonerTimer_Offhand, PoisonerTimer_OffhandIcon, 17, 0.5)
						end
						Poisoner_MinWarning2 = true
					elseif (not Poisoner_MinWarning2) and (offHandExpiration <= WarningThreshold) then
						Poisoner_MinWarning2 = true
					end
					
				else
					if (not Poisoner_NoPoison_Warning2) then
						if (POISONER_CONFIG.Timer.Output.Audio == 1) then
							PoisonerSound_PlaySound("nopoison")
						end
						if (POISONER_CONFIG.Timer.Output.Chat == 1) then
							PoisonerTimer_Print("Poisoner_NoPoison_Warning", DEFAULT_CHAT_FRAME, INVTYPE_WEAPONOFFHAND, _, _, 34)
						end
						if (POISONER_CONFIG.Timer.Output.ErrorFrame == 1) then
							PoisonerTimer_Print("Poisoner_NoPoison_Warning", UIErrorsFrame, INVTYPE_WEAPONOFFHAND, _, _, 34)
						end
						Poisoner_NoPoison_Warning2 = true
					end
					if (POISONER_CONFIG.Timer.Output.Aura == 1) then
						PoisonerTimer_UpdateIconFrame(PoisonerTimer_Offhand, PoisonerTimer_OffhandIcon, 17, 1)
					end
				end
			else
				--print("NO offhand weapon equipped")
				PoisonerTimer_Offhand:Hide()
				Poisoner_MinWarning2 = false
				Poisoner_NoPoison_Warning2 = false
			end
				
				-- Throw weapon
			if PoisonerTimer_ThrowWeapon_itemType == ENCHSLOT_WEAPON and POISONER_CONFIG.Timer.Weapon.ThrowWeapon == 1 then
				PoisonerTimer_UpdateIconTexture(PoisonerTimer_Throwweapon, PoisonerTimer_ThrowweaponIcon, 18)
				local weaponName, weaponLink, weaponRarity, weaponLevel, weaponMinLevel, weaponType, weaponSubType, weaponStackCount, weaponEquipLoc, weaponTexture, weaponSellPrice = GetItemInfo(GetInventoryItemID("player", "18"));
				local weaponSubTypeEquiped, rank, icon, cost, isFunnel, powerType, castTime, minRange, maxRange = GetSpellInfo(2567);
				local isThrowWeapon, EqualStrings = string.find(weaponSubType, ""..weaponSubTypeEquiped.."")
				if hasThrownEnchant then 
					Poisoner_PoisonTimeLeft3 = Poisoner_round((thrownExpiration/60000), 0)	--math.floor(thrownExpiration/60000)
					local timeformat = PoisonerOptions_LB_TimerOutput_Text_Minutes
					if thrownExpiration <= 30000 then
						Poisoner_PoisonTimeLeft3 = Poisoner_round((thrownExpiration/1000), 0)
						timeformat = PoisonerOptions_LB_TimerOutput_Text_Seconds
					end
					Poisoner_NoPoison_Warning3 = false
					
					if thrownExpiration >= WarningThreshold then
						Poisoner_MinWarning3 = false
						PoisonerTimer_Throwweapon:Hide()
					end
					if (not Poisoner_MinWarning3) and (thrownExpiration <= WarningThreshold) and ( Poisoner_PoisonTimeLeft3 ~= 0 ) and thrownExpiration > 0 then
						if (POISONER_CONFIG.Timer.Output.Audio == 1) and (not Poisoner_MinWarning3) then
							PoisonerSound_PlaySound("expiring")
						end
						if (POISONER_CONFIG.Timer.Output.Chat == 1) and (not Poisoner_MinWarning3) then			
							PoisonerTimer_Print("Poisoner_ExpirationWarning", DEFAULT_CHAT_FRAME, INVTYPE_THROWN, Poisoner_PoisonTimeLeft3, timeformat, 33)
						end
						if (POISONER_CONFIG.Timer.Output.ErrorFrame == 1) and (not Poisoner_MinWarning3) then
							PoisonerTimer_Print("Poisoner_ExpirationWarning", UIErrorsFrame, INVTYPE_THROWN, Poisoner_PoisonTimeLeft3, timeformat, 35)
						end
						if (POISONER_CONFIG.Timer.Output.Aura == 1) and (not Poisoner_MinWarning3) then
							PoisonerTimer_UpdateIconFrame(PoisonerTimer_Throwweapon, PoisonerTimer_ThrowweaponIcon, 18, 0.5)
						end
						Poisoner_MinWarning3 = true
					elseif (not Poisoner_MinWarning3) and (thrownExpiration <= WarningThreshold) then
						Poisoner_MinWarning3 = true
					end
					
				elseif (isThrowWeapon and (EqualStrings >= 5)) then
					if (not Poisoner_NoPoison_Warning3) then
						if (POISONER_CONFIG.Timer.Output.Audio == 1) then
							PoisonerSound_PlaySound("nopoison")
						end
						if (POISONER_CONFIG.Timer.Output.Chat == 1) then
							PoisonerTimer_Print("Poisoner_NoPoison_Warning", DEFAULT_CHAT_FRAME, INVTYPE_THROWN, _, _, 35)
						end
						if (POISONER_CONFIG.Timer.Output.ErrorFrame == 1) then
							PoisonerTimer_Print("Poisoner_NoPoison_Warning", UIErrorsFrame, INVTYPE_THROWN, _, _, 35)
						end
						Poisoner_NoPoison_Warning3 = true
					end
					if (POISONER_CONFIG.Timer.Output.Aura == 1) then
						PoisonerTimer_UpdateIconFrame(PoisonerTimer_Throwweapon, PoisonerTimer_ThrowweaponIcon, 18, 1)
					end
				elseif ( not isThrowWeapon ) then
					PoisonerTimer_Throwweapon:Hide()
					Poisoner_MinWarning3 = false
					Poisoner_NoPoison_Warning3 = false
				end

			else
				--print("NO throw weapon equipped")
				PoisonerTimer_Throwweapon:Hide()
				Poisoner_MinWarning3 = false
				Poisoner_NoPoison_Warning3 = false
			end		
		end
	else
		PoisonerTimer_Disable()
	end
end

function PoisonerTimer_Disable()
	PoisonerTimer_Mainhand:Hide()
	PoisonerTimer_Offhand:Hide()
	PoisonerTimer_Throwweapon:Hide()
	Poisoner_MinWarning1 = false
	Poisoner_NoPoison_Warning1 = false
	Poisoner_MinWarning2 = false
	Poisoner_NoPoison_Warning2 = false
	Poisoner_MinWarning3 = false
	Poisoner_NoPoison_Warning3 = false
end

function PoisonerTimer_Print(msgtype, targetframe, slot, timeleft, timeformat, id)

	if (msgtype == "Poisoner_NoPoison_Warning") then
	
		local message = string.gsub(PoisonerOptions_LB_TimerOutput_Message_NoPoison, "{weapon}", slot)			
		if targetframe == UIErrorsFrame then
			--UIErrorsFrame:AddMessage(""..slot.." "..COLOR_RED.."not"..COLOR_END.." "..COLOR_GREEN.."poisoned"..COLOR_END.."", 1,1,1, id, 9);
			UIErrorsFrame:AddMessage(message, 1,1,1, id, 9);
		else
			--targetframe:AddMessage(""..slot.." "..COLOR_RED.."not"..COLOR_END.." "..COLOR_GREEN.."poisoned"..COLOR_END.."")
			targetframe:AddMessage(message);
		end
	
	elseif (msgtype == "Poisoner_ExpirationWarning") then
	
		local messagestring = COLOR_GREY..PoisonerOptions_LB_TimerOutput_Message_Expiration..COLOR_END
		local message = string.gsub(string.gsub(string.gsub(string.gsub(messagestring, "{poison}", ""..COLOR_GREEN..PoisonerOptions_LB_TimerOutput_Text_Poison..COLOR_END..COLOR_GREY..""), "{weapon}", ""..COLOR_END..slot..COLOR_GREY..""), "{time}", ""..COLOR_END..timeleft..COLOR_GREY..""), "{timeformat}", ""..COLOR_END..timeformat..COLOR_GREY.."")
		
		if (timeleft == nil) then
			timeleft = "0";
		end
		if (targetframe == UIErrorsFrame) then
			UIErrorsFrame:AddMessage(message, 1,1,1, id, 9);
		else
			--targetframe:AddMessage(""..COLOR_GREEN.."Poison"..COLOR_END..COLOR_GREY.." on "..COLOR_END..slot..COLOR_GREY.." expires in "..COLOR_END..timeleft)
			targetframe:AddMessage(message);
		end
		
	end
	
end



function PoisonerTimer_CreateIconFrame()

--	IconFrame
	local f = CreateFrame("Frame", "PoisonerTimer_IconFrame", UIParent)
	f:SetFrameStrata("BACKGROUND")
	f:SetWidth(192) 
	f:SetHeight(64)
	
	local t = f:CreateTexture("PoisonerTimer_IconFrameBackground","BACKGROUND")
	t:SetTexture(1,1,1,0)
	t:SetAllPoints(f)
	f.texture = t
	
	f:SetPoint("CENTER","UIParent","CENTER",0,0)
	f:Show()
	
--	Mainhand
	local f = CreateFrame("Frame", "PoisonerTimer_Mainhand", PoisonerTimer_IconFrame)
	f:SetFrameStrata("BACKGROUND")
	f:SetWidth(64) 
	f:SetHeight(64)
	
	local t = f:CreateTexture("PoisonerTimer_MainhandIcon","ARTWORK")
	t:SetTexture(1,1,1,1)
	t:SetAllPoints(f)
	f.texture = t

	f:SetPoint("TOPLEFT",PoisonerTimer_IconFrame,"TOPLEFT",0,0)
	f:Hide()

--	Offhand
	local f = CreateFrame("Frame", "PoisonerTimer_Offhand", PoisonerTimer_IconFrame)
	f:SetFrameStrata("BACKGROUND")
	f:SetWidth(64) 
	f:SetHeight(64)
	
	local t = f:CreateTexture("PoisonerTimer_OffhandIcon","ARTWORK")
	t:SetTexture(1,1,1,1)
	t:SetAllPoints(f)
	f.texture = t

	f:SetPoint("TOP",PoisonerTimer_IconFrame,"TOP",0,0)
	f:Hide()

--	Throw weapon
	local f = CreateFrame("Frame", "PoisonerTimer_Throwweapon", PoisonerTimer_IconFrame)
	f:SetFrameStrata("BACKGROUND")
	f:SetWidth(64) 
	f:SetHeight(64)
	
	local t = f:CreateTexture("PoisonerTimer_ThrowweaponIcon","ARTWORK")
	t:SetTexture(1,1,1,1)
	t:SetAllPoints(f)
	f.texture = t

	f:SetPoint("TOPRIGHT",PoisonerTimer_IconFrame,"TOPRIGHT",0,0)
	f:Hide()
	
end
--[[
function PoisonerTimer_OnEvent(self, event)
	if (event == "VARIABLES_LOADED") then
		if (POISONER_CONFIG.Enabled == 1) and (POISONER_CONFIG.StartedOnce == 1) then
			PoisonerTimer_Frame:SetScript("OnUpdate", PoisonerTimer_OnUpdate)
		end
		PoisonerTimer_Frame:SetScript("OnEvent", nil)
	end
end
]]
function PoisonerTimer_UpdateIconFrame(frame, icon, id, alpha)
	
	local configAlpha = POISONER_CONFIG.Timer.Alpha
	local RealAlpha = alpha * configAlpha
	local weaponID = GetInventoryItemID("player", id)
	local weaponName, weaponLink, weaponRarity, weaponLevel, weaponMinLevel, weaponType, weaponSubType, weaponStackCount, weaponEquipLoc, weaponTexture, weaponSellPrice = GetItemInfo(weaponID)
	icon:SetTexture(weaponTexture)
	icon:SetAlpha(RealAlpha);
	frame:Show()
	
end

function PoisonerTimer_UpdateIconTexture(frame, icon, id)
	
	local weaponID = GetInventoryItemID("player", id)
	local weaponName, weaponLink, weaponRarity, weaponLevel, weaponMinLevel, weaponType, weaponSubType, weaponStackCount, weaponEquipLoc, weaponTexture, weaponSellPrice = GetItemInfo(weaponID)
	icon:SetTexture(weaponTexture)
	
end


function PoisonerTimer_UpdateLock()
	
	if (POISONER_CONFIG.Timer.Lock == 1) then
		PoisonerTimer_IconFrame:RegisterForDrag()
		PoisonerTimer_IconFrameBackground:SetTexture(0,1,0,0)
		PoisonerTimer_IconFrame:SetMovable(false)
		PoisonerTimer_IconFrame:EnableMouse(false)
		PoisonerTimer_IconFrame:SetScript("OnDragStart", nil)
		PoisonerTimer_IconFrame:SetScript("OnDragStop", nil)
	else
		PoisonerTimer_IconFrame:Show()
		PoisonerTimer_IconFrame:RegisterForDrag("LeftButton")
		PoisonerTimer_IconFrameBackground:SetTexture(0,1,0,1)
		PoisonerTimer_IconFrame:SetMovable(true)
		PoisonerTimer_IconFrame:EnableMouse(true)
		PoisonerTimer_IconFrame:SetScript("OnDragStart", PoisonerTimer_OnDragStart)
		PoisonerTimer_IconFrame:SetScript("OnDragStop", PoisonerTimer_OnDragStop)
	end
end


-- Start dragging MainFrame / Toolbar
function PoisonerTimer_OnDragStart(self)
	
	self:StartMoving();
	PoisonerTimer_BeingDragged = true;
	
end

-- Stop dragging MainFrame / Toolbar
function PoisonerTimer_OnDragStop(self)
	if (PoisonerTimer_BeingDragged) then
		self:StopMovingOrSizing()
		POISONER_CONFIG.Timer.Position.Anchor, POISONER_CONFIG.Timer.Position.RelativeTo, POISONER_CONFIG.Timer.Position.RelativePoint, POISONER_CONFIG.Timer.Position.XPos, POISONER_CONFIG.Timer.Position.YPos = PoisonerTimer_IconFrame:GetPoint();
		PoisonerTimer_BeingDragged = false;
	end
end

function PoisonerTimer_WeaponType()

	local _,_,MainHand_ID = string.find(GetInventoryItemLink("player",GetInventorySlotInfo("MainHandSlot")) or "","(item:%d+:%d+:%d+:%d+)")
	if (MainHand_ID ~= nil) then
		_,_,_,_,_,PoisonerTimer_MainHand_itemType,PoisonerTimer_MainHand_itemSubType = GetItemInfo(MainHand_ID)
		print("MH: "..MainHand_ID)
	elseif (MainHand_ID == nil) then
		PoisonerTimer_MainHand_itemType = "";
	end
	
	local _,_,OffHand_ID = string.find(GetInventoryItemLink("player",GetInventorySlotInfo("SecondaryHandSlot")) or "","(item:%d+:%d+:%d+:%d+)")
	if (OffHand_ID ~= nil) then
		_,_,_,_,_,PoisonerTimer_OffHand_itemType,PoisonerTimer_OffHand_itemSubType = GetItemInfo(OffHand_ID)
		print("OH: "..OffHand_ID)
	elseif (OffHand_ID == nil) then
		PoisonerTimer_OffHand_itemType = "";
	end
	
	local _,_,ThrowWeapon_ID = string.find(GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")) or "","(item:%d+:%d+:%d+:%d+)")
	if (ThrowWeapon_ID ~= nil) then
		_,_,_,_,_,PoisonerTimer_ThrowWeapon_itemType,PoisonerTimer_ThrowWeapon_itemSubType = GetItemInfo(ThrowWeapon_ID)
		print("TW: "..ThrowWeapon_ID)
	elseif (ThrowWeapon_ID == nil) then
		PoisonerTimer_ThrowWeapon_itemType = "";
	end
	
	print("Mainhand: "..PoisonerTimer_MainHand_itemType.."\nOffhand: "..PoisonerTimer_OffHand_itemType.."\nThrowWeapon: "..PoisonerTimer_ThrowWeapon_itemType.."")
		
	if PoisonerTimer_MainHand_itemType == ENCHSLOT_WEAPON then
		print("Mainhand is a "..PoisonerTimer_MainHand_itemSubType)
	else
		print("Mainhand is NOT a weapon")
	end
	if PoisonerTimer_OffHand_itemType == ENCHSLOT_WEAPON then
		print("Offhand is a "..PoisonerTimer_OffHand_itemSubType)
	else
		print("Offhand is NOT a weapon")
	end
	if PoisonerTimer_ThrowWeapon_itemType == ENCHSLOT_WEAPON then
		print("Throw/Range is a "..PoisonerTimer_ThrowWeapon_itemSubType)
	else
		print("Throw/Range is NOT a weapon")
	end
	
	local isfishingpole = select(7,GetItemInfo(6256))
	if PoisonerTimer_MainHand_itemSubType == isfishingpole then
		print("MainHand weapon is a fishing pole")
	end
	
end