


local function RestoreDefaults(info)
	DeathClock:RestoreFrameDefaults(info.arg)
	DeathClock:ApplySettings()
end


local function GetFontList()
	return AceGUIWidgetLSMlists.font
end

local function GetFrameValue(info)
	if not DeathClock.db.profile[info.arg[1]] then
		DeathClock.db.profile[info.arg[1]] = DeathClock:GetTableDefaults(info.arg[1])
	end
	return DeathClock.db.profile[info.arg[1]][info.arg[2]]
end

local function SetFrameValue(info, value)
	local self = info.handler
	local profile = self.db.profile
	profile[info.arg[1]][info.arg[2]] = value
	self:ApplySettings()
end


local function GetValue(info)
	return DeathClock.db.profile[info.arg]
end

local function SetValue(info, value)
	DeathClock.db.profile[info.arg] = value
	DeathClock:ApplySettings()
end

local function GetColorValue(info)
	if not DeathClock.db.profile[info.arg[1]] then
		DeathClock.db.profile[info.arg[1]] = DeathClock:GetTableDefaults(info.arg[1])
	end
	local color = DeathClock.db.profile[info.arg[1]][info.arg[2]]
	return color.r, color.g, color.b, color.a
end

local function SetColorValue(info, r, g, b, a)
	local self = info.handler
	local profile = self.db.profile
	profile[info.arg[1]][info.arg[2]].r = r
	profile[info.arg[1]][info.arg[2]].g = g
	profile[info.arg[1]][info.arg[2]].b = b
	profile[info.arg[1]][info.arg[2]].a = a
	self:ApplySettings()
end







local options = {
	name = 'Death Clock',
	type = 'group',
	desc = 'Display an estimated kill time for your target, focus target and any mobs in the blizzard boss frames.',
	set = SetValue,
	get = GetValue,
	handler = DeathClock,
	args = {
	

		["Show"] = {
			name = "Enabled",
			type = 'toggle',
			order = 10,
			width = 'full',
			arg = "enable",
			disabled = false,
		},
		["Lock"] = {
			name = "Locked",
			type = 'toggle',
			order = 20,
			width = 'full',
			arg = "lock",
			disabled = false,
		},
	
	
		["TARGET_FRAME"] = {
			name = "Target",
			type = 'group',
			order = 100,
			set = SetFrameValue,
			get = GetFrameValue,
			args = {
				["Show"] = {
					name = "Show",
					type = 'toggle',
					order = 100,
					width = 'full',
					arg = {"target",'show'},
					disabled = false,
				},
				["Font Size"] = {
					name = "Font Size",
					type = 'range',
					min = 4, max = 20, step = 1,
					order = 150,
					arg = {"target",'size'},
				},
				["BREAK1"] = {
					name = "",
					type = 'description',
					order = 160,
				},
				["Font"] = {
					name = "Font",
					type = 'select',
					dialogControl = 'LSM30_Font',
					values = GetFontList,
					order = 200,
					arg = {"target",'font'},
				},
				["FColor"] = {
					name = "Text Color",
					type = 'color',
					width = 'full',
					hasAlpha = true,
					set = SetColorValue,
					get = GetColorValue,
					order = 350,
					arg = {"target",'foreground'},
				},
				["Outline"] = {
					name = "Outline",
					type = 'select',
					desc = "Set font outline.",
					values = {[''] = NONE, OUTLINE = VOICE_CHAT_NORMAL, THICKOUTLINE = "Thick"},
					order = 425,
					arg = {"target",'outline'},
				},
				["BColor"] = {
					name = "Background",
					type = 'color',
					hasAlpha = true,
					width = 'full',
					set = SetColorValue,
					get = GetColorValue,
					order = 450,
					arg = {"target",'background'},
				},
				["BREAK3"] = {
					name = " \n \n \n \n \n ",
					type = 'description',
					order = 525,
				},
				["Reset"] = {
					name = "Restore Defaults",
					func = RestoreDefaults,
					type = 'execute',
					order = 550,
					arg = "target",
				},
			}
		},
	
		["FOCUS_FRAME"] = {
			name = "Focus",
			type = 'group',
			order = 150,
			set = SetFrameValue,
			get = GetFrameValue,
			args = {
				["Show"] = {
					name = "Show",
					type = 'toggle',
					order = 100,
					width = 'full',
					arg = {"focus",'show'},
					disabled = false,
				},
				["Font Size"] = {
					name = "Font Size",
					type = 'range',
					min = 4, max = 20, step = 1,
					order = 150,
					arg = {"focus",'size'},
				},
				["BREAK1"] = {
					name = "",
					type = 'description',
					order = 160,
				},
				["Font"] = {
					name = "Font",
					type = 'select',
					dialogControl = 'LSM30_Font',
					values = GetFontList,
					order = 200,
					arg = {"focus",'font'},
				},
				["FColor"] = {
					name = "Text Color",
					type = 'color',
					width = 'full',
					hasAlpha = true,
					set = SetColorValue,
					get = GetColorValue,
					order = 350,
					arg = {"focus",'foreground'},
				},
				["Outline"] = {
					name = "Outline",
					type = 'select',
					desc = "Set font outline.",
					values = {[''] = NONE, OUTLINE = VOICE_CHAT_NORMAL, THICKOUTLINE = "Thick"},
					order = 425,
					arg = {"focus",'outline'},
				},
				["BColor"] = {
					name = "Background",
					type = 'color',
					width = 'full',
					hasAlpha = true,
					set = SetColorValue,
					get = GetColorValue,
					order = 450,
					arg = {"focus",'background'},
				},
				["BREAK3"] = {
					name = " \n \n \n \n \n ",
					type = 'description',
					order = 525,
				},
				["Reset"] = {
					name = "Restore Defaults",
					func = RestoreDefaults,
					type = 'execute',
					order = 550,
					arg = "focus",
				},
			}
		},	
		
		["BOSS_FRAME1"] = {
			name = "Boss 1",
			type = 'group',
			order = 200,
			set = SetFrameValue,
			get = GetFrameValue,
			args = {
				["Show"] = {
					name = "Show",
					type = 'toggle',
					order = 100,
					width = 'full',
					arg = {"boss1",'show'},
					disabled = false,
				},
				["Font Size"] = {
					name = "Font Size",
					type = 'range',
					min = 4, max = 20, step = 1,
					order = 150,
					arg = {"boss1",'size'},
				},
				["BREAK1"] = {
					name = "",
					type = 'description',
					order = 160,
				},
				["Font"] = {
					name = "Font",
					type = 'select',
					dialogControl = 'LSM30_Font',
					values = GetFontList,
					order = 200,
					arg = {"boss1",'font'},
				},
				["FColor"] = {
					name = "Text Color",
					type = 'color',
					width = 'full',
					hasAlpha = true,
					set = SetColorValue,
					get = GetColorValue,
					order = 350,
					arg = {"boss1",'foreground'},
				},
				["Outline"] = {
					name = "Outline",
					type = 'select',
					desc = "Set font outline.",
					values = {[''] = NONE, OUTLINE = VOICE_CHAT_NORMAL, THICKOUTLINE = "Thick"},
					order = 425,
					arg = {"boss1",'outline'},
				},
				["BColor"] = {
					name = "Background",
					type = 'color',
					hasAlpha = true,
					width = 'full',
					set = SetColorValue,
					get = GetColorValue,
					order = 450,
					arg = {"boss1",'background'},
				},
				["BREAK3"] = {
					name = " \n \n \n \n \n ",
					width = 'full',
					type = 'description',
					order = 525,
				},
				["Reset"] = {
					name = "Restore Defaults",
					func = RestoreDefaults,
					type = 'execute',
					order = 550,
					arg = "boss1",
				},
			}
		},
		
		
		["BOSS_FRAME2"] = {
			name = "Boss 2",
			type = 'group',
			order = 250,
			set = SetFrameValue,
			get = GetFrameValue,
			args = {
				["Show"] = {
					name = "Show",
					type = 'toggle',
					order = 100,
					width = 'full',
					arg = {"boss2",'show'},
					disabled = false,
				},
				["Font Size"] = {
					name = "Font Size",
					type = 'range',
					min = 4, max = 20, step = 1,
					order = 150,
					arg = {"boss2",'size'},
				},
				["BREAK1"] = {
					name = "",
					type = 'description',
					order = 160,
				},
				["Font"] = {
					name = "Font",
					type = 'select',
					dialogControl = 'LSM30_Font',
					values = GetFontList,
					order = 200,
					arg = {"boss2",'font'},
				},
				["FColor"] = {
					name = "Text Color",
					type = 'color',
					width = 'full',
					hasAlpha = true,
					set = SetColorValue,
					get = GetColorValue,
					order = 350,
					arg = {"boss2",'foreground'},
				},
				["Outline"] = {
					name = "Outline",
					type = 'select',
					desc = "Set font outline.",
					values = {[''] = NONE, OUTLINE = VOICE_CHAT_NORMAL, THICKOUTLINE = "Thick"},
					order = 425,
					arg = {"boss2",'outline'},
				},
				["BColor"] = {
					name = "Background",
					type = 'color',
					width = 'full',
					hasAlpha = true,
					set = SetColorValue,
					get = GetColorValue,
					order = 450,
					arg = {"boss2",'background'},
				},
				["BREAK3"] = {
					name = " \n \n \n \n \n ",
					type = 'description',
					order = 525,
				},
				["Reset"] = {
					name = "Restore Defaults",
					func = RestoreDefaults,
					type = 'execute',
					order = 550,
					arg = "boss2",
				},
			}
		},	
		
		
		["BOSS_FRAME3"] = {
			name = "Boss 3",
			type = 'group',
			order = 300,
			set = SetFrameValue,
			get = GetFrameValue,
			args = {
				["Show"] = {
					name = "Show",
					type = 'toggle',
					order = 100,
					width = 'full',
					arg = {"boss3",'show'},
					disabled = false,
				},
				["Font Size"] = {
					name = "Font Size",
					type = 'range',
					min = 4, max = 20, step = 1,
					order = 150,
					arg = {"boss3",'size'},
				},
				["BREAK1"] = {
					name = "",
					type = 'description',
					order = 160,
				},
				["Font"] = {
					name = "Font",
					type = 'select',
					dialogControl = 'LSM30_Font',
					values = GetFontList,
					order = 200,
					arg = {"boss3",'font'},
				},
				["FColor"] = {
					name = "Text Color",
					type = 'color',
					width = 'full',
					hasAlpha = true,
					set = SetColorValue,
					get = GetColorValue,
					order = 350,
					arg = {"boss3",'foreground'},
				},
				["Outline"] = {
					name = "Outline",
					type = 'select',
					desc = "Set font outline.",
					values = {[''] = NONE, OUTLINE = VOICE_CHAT_NORMAL, THICKOUTLINE = "Thick"},
					order = 425,
					arg = {"boss3",'outline'},
				},
				["BColor"] = {
					name = "Background",
					type = 'color',
					width = 'full',
					hasAlpha = true,
					set = SetColorValue,
					get = GetColorValue,
					order = 450,
					arg = {"boss3",'background'},
				},
				["BREAK3"] = {
					name = " \n \n \n \n \n ",
					type = 'description',
					order = 525,
				},
				["Reset"] = {
					name = "Restore Defaults",
					func = RestoreDefaults,
					type = 'execute',
					order = 550,
					arg = "boss3",
				},
			}
		},	
		
		
		["BOSS_FRAME4"] = {
			name = "Boss 4",
			type = 'group',
			order = 350,
			set = SetFrameValue,
			get = GetFrameValue,
			args = {
				["Show"] = {
					name = "Show",
					type = 'toggle',
					order = 100,
					width = 'full',
					arg = {"boss4",'show'},
					disabled = false,
				},
				["Font Size"] = {
					name = "Font Size",
					type = 'range',
					min = 4, max = 20, step = 1,
					order = 150,
					arg = {"boss4",'size'},
				},
				["BREAK1"] = {
					name = "",
					type = 'description',
					order = 160,
				},
				["Font"] = {
					name = "Font",
					type = 'select',
					dialogControl = 'LSM30_Font',
					values = GetFontList,
					order = 200,
					arg = {"boss4",'font'},
				},
				["FColor"] = {
					name = "Text Color",
					type = 'color',
					width = 'full',
					set = SetColorValue,
					get = GetColorValue,
					order = 350,
					hasAlpha = true,
					arg = {"boss4",'foreground'},
				},
				["Outline"] = {
					name = "Outline",
					type = 'select',
					desc = "Set font outline.",
					values = {[''] = NONE, OUTLINE = VOICE_CHAT_NORMAL, THICKOUTLINE = "Thick"},
					order = 425,
					arg = {"boss4",'outline'},
				},
				["BColor"] = {
					name = "Background",
					type = 'color',
					width = 'full',
					hasAlpha = true,
					set = SetColorValue,
					get = GetColorValue,
					order = 450,
					arg = {"boss4",'background'},
				},
				["BREAK3"] = {
					name = " \n \n \n \n \n ",
					type = 'description',
					order = 525,
				},
				["Reset"] = {
					name = "Restore Defaults",
					func = RestoreDefaults,
					type = 'execute',
					order = 550,
					arg = "boss4",
				},
			},
		},	
	},
}

function DeathClock:GetTableDefaults(unitID)
	local defaults = { 
		show = true,
		background = {r = 0,b = 0,g = 0, a = .25},
		foreground = {r = 1,b = 1,g = 1, a = 1},
		font = "DorisPP",
		size = 6,
		outline = 'OUTLINE',
		height = 16,
		width = 51,
	}
	defaults.p1, defaults.anchorFrame, defaults.p2, defaults.x, defaults.y = DeathClock:GetAnchorFrame(unitID)
	return defaults
end

function DeathClock:GetDefaults()
	return {
		profile = {
			enable = true,
			lock = false,
			timeBetweenUpdates = 1,
		}
	}
end

function DeathClock:ProfileChanged()
	for _,frame in pairs(self.frames) do
		frame.anchorSecure = nil
	end
	self:ApplySettings()
end

function DeathClock:RegisterOptions()
 	self.db = LibStub('AceDB-3.0'):New('DeathClockDB', self:GetDefaults(), 'Default')
	self.db.RegisterCallback(self, "OnProfileChanged", "ProfileChanged")
	self.db.RegisterCallback(self, "OnProfileCopied", "ProfileChanged")
	self.db.RegisterCallback(self, "OnProfileReset", "ProfileChanged")
	self:RegisterMedia()
	
	local profileOptions = LibStub("AceDBOptions-3.0"):GetOptionsTable(self.db)
	local registry = LibStub('AceConfigRegistry-3.0')
	local dialog = LibStub('AceConfigDialog-3.0')
	
	registry:RegisterOptionsTable('Death Clock', options)
	local main = dialog:AddToBlizOptions('Death Clock', 'Death Clock')
	
	registry:RegisterOptionsTable("Death Clock Profile", profileOptions)
	dialog:AddToBlizOptions("Death Clock Profile", "Profile", "Death Clock")
end

function DeathClock:RegisterMedia()
	local media = LibStub("LibSharedMedia-3.0");
	media:Register("font", "ABF",					[[Interface\Addons\death-clock\fonts\ABF.ttf]])
	media:Register("font", "Accidental Presidency",	[[Interface\Addons\death-clock\fonts\Accidental Presidency.ttf]])
	media:Register("font", "Adventure",				[[Interface\Addons\death-clock\fonts\Adventure.ttf]])
	media:Register("font", "AnonymousPro (Bold)",	[[Interface\Addons\death-clock\fonts\AnonymousPro-Bold.ttf]])
	media:Register("font", "Avqest",				[[Interface\Addons\death-clock\fonts\Avqest.ttf]])
	media:Register("font", "Bazooka",				[[Interface\Addons\death-clock\fonts\Bazooka.ttf]])
	media:Register("font", "BigNoodleTitling",		[[Interface\Addons\death-clock\fonts\BigNoodleTitling.ttf]])
	media:Register("font", "BigNoodleTitling-Oblique",[[Interface\Addons\death-clock\fonts\BigNoodleTitling-Oblique.ttf]])
	media:Register("font", "BlackChancery",			[[Interface\Addons\death-clock\fonts\BlackChancery.ttf]])
	media:Register("font", "CRYSRG__",				[[Interface\Addons\death-clock\fonts\CRYSRG__.ttf]])
	media:Register("font", "DejaVuSansMono",		[[Interface\Addons\death-clock\fonts\DejaVuSansMono.ttf]])
	media:Register("font", "DorisPP",				[[Interface\Addons\death-clock\fonts\DORISPP.ttf]])
	media:Register("font", "Emblem",				[[Interface\Addons\death-clock\fonts\Emblem.ttf]])
	media:Register("font", "Enigma__2",				[[Interface\Addons\death-clock\fonts\Enigma__2.ttf]])
	media:Register("font", "FSEX300",				[[Interface\Addons\death-clock\fonts\FSEX300.ttf]])
	media:Register("font", "JAi_____",				[[Interface\Addons\death-clock\fonts\JAi_____.ttf]])
	media:Register("font", "LiberationSans Regular",[[Interface\Addons\death-clock\fonts\LiberationSans-Regular.ttf]])
	media:Register("font", "MONOFONT",				[[Interface\Addons\death-clock\fonts\MONOFONT.ttf]])
	media:Register("font", "Movie Poster (Bold)",	[[Interface\Addons\death-clock\fonts\Movie_Poster-Bold.ttf]])
	media:Register("font", "Porky",					[[Interface\Addons\death-clock\fonts\Porky.ttf]])
	media:Register("font", "rm_midse",				[[Interface\Addons\death-clock\fonts\rm_midse.ttf]])
	media:Register("font", "Tangerin",				[[Interface\Addons\death-clock\fonts\Tangerin.ttf]])
	media:Register("font", "Tw_Cen_MT_Bold",		[[Interface\Addons\death-clock\fonts\Tw_Cen_MT_Bold.ttf]])
	media:Register("font", "Ultima Campagnoli",		[[Interface\Addons\death-clock\fonts\Ultima_Campagnoli.ttf]])
	media:Register("font", "VeraSe",				[[Interface\Addons\death-clock\fonts\VeraSe.ttf]])
	media:Register("font", "WHITRABT",				[[Interface\Addons\death-clock\fonts\WHITRABT.ttf]])
	media:Register("font", "Yellow Jacket",			[[Interface\Addons\death-clock\fonts\Yellowjacket.ttf]])
end
