local LubStub = LibStub
local DeathClock = LibStub('AceAddon-3.0'):NewAddon('DeathClock', 'AceTimer-3.0', 'AceEvent-3.0', 'AceConsole-3.0')
_G.DeathClock = DeathClock
local SML = LibStub("LibSharedMedia-3.0")
local debug = false
local WorldGetNumChildren, WorldGetChildren = WorldFrame.GetNumChildren, WorldFrame.GetChildren
local units = {}
local unitIDs = {"target","focus","mouseover","boss1","boss2","boss3","boss4"}
do
	for i = 1, 40 do
		tinsert(unitIDs,"raid"..i.."target")
	end
end

local displayedUnitIDs = {"target","focus","boss1","boss2","boss3","boss4"}


function DeathClock:GetAnchorFrame(unitID)
	if unitID == "target" then
		if _G["XPerl_TargetstatsFramehealthBar"] then
			return "TOPRIGHT","XPerl_TargetstatsFramehealthBar","BOTTOMLEFT",0,0
		elseif _G["SUFUnittarget"] then
			return "TOPRIGHT","SUFUnittarget","LEFT",0,0
		else
			return "TOPRIGHT","TargetFrameHealthBar","BOTTOMLEFT",0,0
		end
	elseif unitID == "focus" then
		if _G["XPerl_FocusstatsFramehealthBar"] then
			return "TOPRIGHT","XPerl_FocusstatsFramehealthBar","BOTTOMLEFT",0,0
		elseif _G["SUFUnitfocus"] then
			return "TOPRIGHT","SUFUnitfocus","LEFT",0,0
		else
			return "TOPRIGHT","FocusFrameHealthBar","BOTTOMLEFT",0,0
		end
	elseif unitID == "boss1" then
		if _G["SUFHeaderbossUnitButton1"] then
			return "TOPRIGHT","SUFHeaderbossUnitButton1","LEFT",0,0
		else
			return "TOPRIGHT","Boss1TargetFrameHealthBar","BOTTOMLEFT",0,0
		end
	elseif unitID == "boss2" then
		if _G["SUFHeaderbossUnitButton2"] then
			return "TOPRIGHT","SUFHeaderbossUnitButton2","LEFT",0,0
		else
			return "TOPRIGHT","Boss2TargetFrameHealthBar","BOTTOMLEFT",0,0
		end
	elseif unitID == "boss3" then
		if _G["SUFHeaderbossUnitButton3"] then
			return "TOPRIGHT","SUFHeaderbossUnitButton3","LEFT",0,0
		else
			return "TOPRIGHT","Boss3TargetFrameHealthBar","BOTTOMLEFT",0,0
		end
	elseif unitID == "boss4" then
		if _G["SUFHeaderbossUnitButton4"] then
			return "TOPRIGHT","SUFHeaderbossUnitButton4","LEFT",0,0
		else
			return "TOPRIGHT","Boss4TargetFrameHealthBar","BOTTOMLEFT",0,0
		end
	else
		return "CENTER",nil,"CENTER",0,0
	end
end

local function ClockUpdate(unit,health) 
	local time = GetTime()

	if not unit.health0 then
		unit.health0, unit.time0 = health, time
		unit.mhealth, unit.mtime = health, time
		unit.text = "..."
		return
	end

	unit.mhealth = (unit.mhealth + health) * .5
	unit.mtime = (unit.mtime + time) * .5

	if unit.mhealth >= unit.health0 then
		unit.text = "..."
		unit.health0, unit.time0 = health, time
		unit.mhealth, unit.mtime = health, time
	else
		time = ceil(health * (unit.time0 - unit.mtime) / (unit.mhealth - unit.health0) )
		if time < 60 then
			unit.text = format('%ds',time)
		elseif time < 3600 then
			unit.text = format('%dm%02ds', 1/60 * time, time % 60)
		elseif time < 86400 then
			unit.text = format('%dh%02dm', 1/3600 * time, 1/60 * (time % 3600))
		else
			unit.text = format('%dd%02dh', 1/86400 * time, 1/3600 * (time % 86400))
		end
	end
end

local function mouset_anchor(frame)
  local x, y = GetCursorPosition();
  local scale = frame:GetEffectiveScale();
  frame:ClearAllPoints();
  frame:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", (x/scale + 20), (y/scale - 20));
end

local function ShowToolTip(frame)	

	GameTooltip:SetOwner(frame, "ANCHOR_NONE");
    mouset_anchor(GameTooltip);
	GameTooltip:SetText( "Death Clock (" .. frame.unit .. ") Unlocked\n   Drag to reposition\n   Right click to lock"  )
	if frame.isDragging then
		GameTooltip:Hide()
	else
		GameTooltip:Show()
	end
end


local function HideToolTip(frame)
	GameTooltip:Hide()
end


local function AnchorFailed(frame)
	local settings = DeathClock.db.profile[frame.unit]
	settings.p1, settings.anchorFrame, settings.p2, settings.x, settings.y = "CENTER",nil,"CENTER",0,0
	DeathClock.db.profile.lock = false
	frame.anchorSecure = 2
	print("The Death Clock for '"..frame.unit.."' can not find the right frame to attach to. The Death Clock is now unlocked and centered on your screen ready to be dragged into position.\n\n Right click the Death Clock to lock it when positioned.")
	DeathClock:ApplySettings(frame)
end

function DeathClock:SetupFrame(unit)
	local frame = CreateFrame("Button", "DeathClock-"..unit)
	frame.unit = unit
	frame:SetFrameStrata("HIGH")
	frame.texture = frame:CreateTexture("bg", "BACKGROUND", "ActionBarButtonTemplate")
	frame.texture:SetAllPoints(frame)
	frame.texture:SetTexture(0,0,0,.8)
	frame.text = frame:CreateFontString("DeathClock-"..unit.."-Text", "OVERLAY")
	frame.text:SetAllPoints(frame)
	frame.text:SetFontObject(TextStatusBarText)
	frame.text:SetJustifyH("RIGHT")
	frame:SetClampedToScreen(true)
	frame:SetMovable(true)
	frame:RegisterForDrag("LeftButton")
	frame:RegisterForClicks("RightButtonUp")
	frame:SetScript("OnDragStart", 
		function(frame) 
			frame:StartMoving() 
			frame.isDragging = true
			HideToolTip(frame)
		end
	)
	frame:SetScript("OnDragStop", 
		function(frame) 
			frame:StopMovingOrSizing() 
			local settings = DeathClock.db.profile[frame.unit]
			local p1,_,p2,x,y = frame:GetPoint()
			settings.x = x
			settings.y = y
			settings.anchorFrame = nil
			settings.p1 = p1
			settings.p2 = p2
			frame.isDragging = false
			ShowToolTip(frame)
		end
	)
	frame:SetScript("OnClick",
		function(frame)
			DeathClock.db.profile.lock = true
			DeathClock:ApplySettings()
		end
	)
	frame:SetScript("OnEnter", ShowToolTip)
	frame:SetScript("OnLeave", HideToolTip)
	
	self.frames[unit] = frame
	self:ApplyFrameSettings(frame)
	return frame
end

function DeathClock:ApplyFrameSettings(frame)
	local settings = self.db.profile[frame.unit]
	if not settings then
		self.db.profile[frame.unit] = self:GetTableDefaults(frame.unit)
		settings = self.db.profile[frame.unit]
	elseif settings.anchorFrame and not _G[settings.anchorFrame] then
		settings.p1, settings.anchorFrame, settings.p2, settings.x, settings.y = DeathClock:GetAnchorFrame(unitID)
	end
	if settings.anchorFrame and _G[settings.anchorFrame] then
		frame:SetParent(_G[settings.anchorFrame])
		frame:SetScale(1/_G[settings.anchorFrame]:GetEffectiveScale())
	else
		frame:SetParent(nil)
		frame:SetScale(1)
	end
	frame:ClearAllPoints()
	frame:SetPoint(settings.p1,settings.anchorFrame,settings.p2,settings.x,settings.y)
	frame.text:SetFont(SML:Fetch('font', settings.font), settings.size, settings.outline)
	frame.text:SetTextColor(settings.foreground.r, settings.foreground.g, settings.foreground.b, settings.foreground.a)
	local oldText = frame.text:GetText()
	frame.text:SetText("99m99s")
	local textWidth = frame.text:GetStringWidth()
	frame.text:SetText(oldText)
	frame:SetWidth(textWidth+2)
	frame:SetHeight(settings.size + 2)
	frame.texture:SetTexture(settings.background.r, settings.background.g, settings.background.b, settings.background.a)
	frame:EnableMouse(not self.db.profile.lock)
end

function DeathClock:OnInitialize()
	self:RegisterOptions()
	self.frames = {}
	
	self:RegisterChatCommand("dc", "SlashCommand")
	self:RegisterChatCommand("deathclock", "SlashCommand")
	self:ApplySettings()
end


function DeathClock:Update()
	local time = GetTime()
	for _,unitID in pairs(unitIDs) do
		local guid = UnitGUID(unitID)
		if guid then
			local unit = units[guid]
			if not unit then
				units[guid] = {updated = time - 1}
				unit = units[guid]
			end
			if unit.updated < time then
				ClockUpdate(unit, UnitHealth(unitID))
			end
		end
	end
	
	for _,unitID in pairs(displayedUnitIDs) do
		local frame = self.frames[unitID]
		if UnitGUID(unitID) then
			if not frame then
				frame = self:SetupFrame(unitID)
			end
			if self.db.profile[unitID].show then
				frame.text:SetText(units[UnitGUID(unitID)].text)
				if frame.anchorSecure ~= 2 then
					local settings = self.db.profile[unitID]
					if settings.anchorFrame and not _G[settings.anchorFrame]:IsVisible() then
						if not frame.anchorSecure then
							frame.anchorSecure = 1
						else
							AnchorFailed(frame)
						end
					else
						frame.anchorSecure = 2
					end
				end
				frame:Show()
			elseif not frame:GetParent() then
				frame:Hide()
			end
		elseif frame and not frame:GetParent() then
			frame:Hide()
		end
	end
end

function DeathClock:RestoreFrameDefaults(unit)
	self.db.profile[unit] = self:GetTableDefaults(unit)
	if self.frames[unit] then
		self.frames[unit].anchorSecure = nil
	end
end

function DeathClock:ApplySettings()
	if self.timer then
		self:CancelTimer(self.timer)
		self.timer = nil
	end
	
	for unitID,frame in pairs(self.frames) do
		self:ApplyFrameSettings( frame)
	end

	if self.db.profile.enable then
		self.timer = self:ScheduleRepeatingTimer("Update", self.db.profile.timeBetweenUpdates)
	else
		for _,plate in pairs(self.frames) do
			plate:Hide()
		end
	end
end


function DeathClock:SlashCommand(info)
	if info == "reset all" then
		self:RestoreFrameDefaults("target")
		self:RestoreFrameDefaults("focus")
		self:RestoreFrameDefaults("boss1")
		self:RestoreFrameDefaults("boss2")
		self:RestoreFrameDefaults("boss3")
		self:RestoreFrameDefaults("boss4")
		self:ApplySettings()
	elseif info == "reset target" then
		self:RestoreFrameDefaults("target")
		self:ApplySettings()
	elseif info == "reset focus" then
		self:RestoreFrameDefaults("focus")
		self:ApplySettings()
	elseif info == "reset boss1" then
		self:RestoreFrameDefaults("boss1")
		self:ApplySettings()
	elseif info == "reset boss2" then
		self:RestoreFrameDefaults("boss2")
		self:ApplySettings()
	elseif info == "reset boss3" then
		self:RestoreFrameDefaults("boss3")
		self:ApplySettings()
	elseif info == "reset boss4" then
		self:RestoreFrameDefaults("boss4")
		self:ApplySettings()
	else
		print("Command List")
		print("     |cff3399FFreset all|r - Restores the default settings for all frames.")
		print("     |cff3399FFreset target|r - Restores the default settings for the target frame.")
		print("     |cff3399FFreset focus|r - Restores the default settings for the focus target frame.")
		print("     |cff3399FFreset boss1|r - Restores the default settings for the first boss frame.")
		print("     |cff3399FFreset boss2|r - Restores the default settings for the second boss frame.")
		print("     |cff3399FFreset boss3|r - Restores the default settings for the third boss frame.")
		print("     |cff3399FFreset boss4|r - Restores the default settings for the fourth boss frame.")
	end
end